/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.Context;
import io.iworkflow.core.StateDecision;
import io.iworkflow.core.command.CommandRequest;
import io.iworkflow.core.command.CommandResults;
import io.iworkflow.core.communication.Communication;
import io.iworkflow.core.persistence.Persistence;
import io.iworkflow.gen.models.WorkflowStateOptions;
import java.lang.reflect.Method;

public interface WorkflowState<I> {
    public Class<I> getInputType();

    default public CommandRequest waitUntil(Context context, I input, Persistence persistence, Communication communication) {
        throw new IllegalStateException("this exception will never be thrown.");
    }

    public StateDecision execute(Context var1, I var2, CommandResults var3, Persistence var4, Communication var5);

    default public String getStateId() {
        return this.getClass().getSimpleName();
    }

    default public WorkflowStateOptions getStateOptions() {
        return null;
    }

    public static boolean shouldSkipWaitUntil(WorkflowState state) {
        Method waitUntilMethod;
        Class<?> stateClass = state.getClass();
        try {
            waitUntilMethod = stateClass.getMethod("waitUntil", Context.class, Object.class, Persistence.class, Communication.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return waitUntilMethod.getDeclaringClass().equals(WorkflowState.class);
    }
}

