/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core;

import io.iworkflow.core.ObjectEncoder;
import io.iworkflow.gen.models.StateCompletionOutput;
import io.iworkflow.gen.models.WorkflowErrorType;
import io.iworkflow.gen.models.WorkflowStatus;
import java.util.List;

public class WorkflowUncompletedException
extends RuntimeException {
    private final String runId;
    private final WorkflowStatus closedStatus;
    private final WorkflowErrorType errorType;
    private final String errorMessage;
    private final List<StateCompletionOutput> stateResults;
    private final ObjectEncoder encoder;

    public WorkflowUncompletedException(String runId, WorkflowStatus closedStatus, WorkflowErrorType errorType, String errorMessage, List<StateCompletionOutput> stateResults, ObjectEncoder encoder) {
        this.runId = runId;
        this.closedStatus = closedStatus;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.stateResults = stateResults;
        this.encoder = encoder;
    }

    public String getRunId() {
        return this.runId;
    }

    public WorkflowStatus getClosedStatus() {
        return this.closedStatus;
    }

    public WorkflowErrorType getErrorSubType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getStateResultsSize() {
        if (this.stateResults == null) {
            return 0;
        }
        return this.stateResults.size();
    }

    public <T> T getStateResult(int index, Class<T> type) {
        StateCompletionOutput output = this.stateResults.get(index);
        return this.encoder.decode(output.getCompletedStateOutput(), type);
    }
}

