/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import io.iworkflow.core.command.BaseCommand;
import io.iworkflow.core.command.ImmutableCommandRequest;
import io.iworkflow.gen.models.CommandCombination;
import io.iworkflow.gen.models.CommandWaitingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class CommandRequest {
    public static final CommandRequest empty = ImmutableCommandRequest.builder().commandWaitingType(CommandWaitingType.ALL_COMPLETED).build();

    public abstract List<BaseCommand> getCommands();

    public abstract List<CommandCombination> getCommandCombinations();

    public abstract CommandWaitingType getCommandWaitingType();

    public static CommandRequest forAllCommandCompleted(BaseCommand ... commands) {
        return ImmutableCommandRequest.builder().addAllCommands(Arrays.asList(commands)).commandWaitingType(CommandWaitingType.ALL_COMPLETED).build();
    }

    public static CommandRequest forAnyCommandCompleted(BaseCommand ... commands) {
        return ImmutableCommandRequest.builder().addAllCommands(Arrays.asList(commands)).commandWaitingType(CommandWaitingType.ANY_COMPLETED).build();
    }

    public static CommandRequest forAnyCommandCombinationCompleted(List<List<String>> commandCombinationLists, BaseCommand ... commands) {
        ArrayList combinations = new ArrayList();
        commandCombinationLists.forEach(commandIds -> combinations.add(new CommandCombination().commandIds((List<String>)commandIds)));
        return ImmutableCommandRequest.builder().commandCombinations(combinations).addAllCommands(Arrays.asList(commands)).commandWaitingType(CommandWaitingType.ANY_COMBINATION_COMPLETED).build();
    }
}

