/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import io.iworkflow.core.command.TimerCommandResult;
import io.iworkflow.core.communication.InterStateChannelCommandResult;
import io.iworkflow.core.communication.SignalCommandResult;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class CommandResults {
    public abstract List<SignalCommandResult> getAllSignalCommandResults();

    public abstract List<TimerCommandResult> getAllTimerCommandResults();

    public abstract List<InterStateChannelCommandResult> getAllInterStateChannelCommandResult();

    public abstract Optional<Boolean> getWaitUntilApiSucceeded();

    public <T> T getSignalValueByIndex(int idx) {
        List<SignalCommandResult> results = this.getAllSignalCommandResults();
        SignalCommandResult value = results.get(idx);
        return (T)value.getSignalValue().get();
    }

    public <T> T getSignalValueById(String commandId) {
        List<SignalCommandResult> results = this.getAllSignalCommandResults();
        for (SignalCommandResult result : results) {
            if (!result.getCommandId().equals(commandId)) continue;
            return (T)result.getSignalValue().get();
        }
        throw new IllegalArgumentException("commandId not found");
    }
}

