/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.command.BaseCommand;
import io.iworkflow.core.command.CommandRequest;
import io.iworkflow.gen.models.CommandCombination;
import io.iworkflow.gen.models.CommandWaitingType;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommandRequest", generator="Immutables")
@Immutable
public final class ImmutableCommandRequest
extends CommandRequest {
    private final ImmutableList<BaseCommand> commands;
    private final ImmutableList<CommandCombination> commandCombinations;
    private final CommandWaitingType commandWaitingType;

    private ImmutableCommandRequest(ImmutableList<BaseCommand> commands, ImmutableList<CommandCombination> commandCombinations, CommandWaitingType commandWaitingType) {
        this.commands = commands;
        this.commandCombinations = commandCombinations;
        this.commandWaitingType = commandWaitingType;
    }

    public ImmutableList<BaseCommand> getCommands() {
        return this.commands;
    }

    public ImmutableList<CommandCombination> getCommandCombinations() {
        return this.commandCombinations;
    }

    @Override
    public CommandWaitingType getCommandWaitingType() {
        return this.commandWaitingType;
    }

    public final ImmutableCommandRequest withCommands(BaseCommand ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommandRequest((ImmutableList<BaseCommand>)newValue, this.commandCombinations, this.commandWaitingType);
    }

    public final ImmutableCommandRequest withCommands(Iterable<? extends BaseCommand> elements) {
        if (this.commands == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommandRequest((ImmutableList<BaseCommand>)newValue, this.commandCombinations, this.commandWaitingType);
    }

    public final ImmutableCommandRequest withCommandCombinations(CommandCombination ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommandRequest(this.commands, (ImmutableList<CommandCombination>)newValue, this.commandWaitingType);
    }

    public final ImmutableCommandRequest withCommandCombinations(Iterable<? extends CommandCombination> elements) {
        if (this.commandCombinations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommandRequest(this.commands, (ImmutableList<CommandCombination>)newValue, this.commandWaitingType);
    }

    public final ImmutableCommandRequest withCommandWaitingType(CommandWaitingType value) {
        CommandWaitingType newValue = Objects.requireNonNull(value, "commandWaitingType");
        if (this.commandWaitingType == newValue) {
            return this;
        }
        return new ImmutableCommandRequest(this.commands, this.commandCombinations, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommandRequest && this.equalTo(0, (ImmutableCommandRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommandRequest another) {
        return this.commands.equals(another.commands) && this.commandCombinations.equals(another.commandCombinations) && this.commandWaitingType.equals((Object)another.commandWaitingType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commands.hashCode();
        h += (h << 5) + this.commandCombinations.hashCode();
        h += (h << 5) + this.commandWaitingType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommandRequest").omitNullValues().add("commands", this.commands).add("commandCombinations", this.commandCombinations).add("commandWaitingType", (Object)this.commandWaitingType).toString();
    }

    public static ImmutableCommandRequest copyOf(CommandRequest instance) {
        if (instance instanceof ImmutableCommandRequest) {
            return (ImmutableCommandRequest)instance;
        }
        return ImmutableCommandRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommandRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMAND_WAITING_TYPE = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<BaseCommand> commands = ImmutableList.builder();
        private ImmutableList.Builder<CommandCombination> commandCombinations = ImmutableList.builder();
        @Nullable
        private CommandWaitingType commandWaitingType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCommands(instance.getCommands());
            this.addAllCommandCombinations(instance.getCommandCombinations());
            this.commandWaitingType(instance.getCommandWaitingType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommands(BaseCommand element) {
            this.commands.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommands(BaseCommand ... elements) {
            this.commands.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commands(Iterable<? extends BaseCommand> elements) {
            this.commands = ImmutableList.builder();
            return this.addAllCommands(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommands(Iterable<? extends BaseCommand> elements) {
            this.commands.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommandCombinations(CommandCombination element) {
            this.commandCombinations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommandCombinations(CommandCombination ... elements) {
            this.commandCombinations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandCombinations(Iterable<? extends CommandCombination> elements) {
            this.commandCombinations = ImmutableList.builder();
            return this.addAllCommandCombinations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommandCombinations(Iterable<? extends CommandCombination> elements) {
            this.commandCombinations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandWaitingType(CommandWaitingType commandWaitingType) {
            this.commandWaitingType = Objects.requireNonNull(commandWaitingType, "commandWaitingType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCommandRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommandRequest(this.commands.build(), this.commandCombinations.build(), this.commandWaitingType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commandWaitingType");
            }
            return "Cannot build CommandRequest, some of required attributes are not set " + attributes;
        }
    }
}

