/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.command.CommandResults;
import io.iworkflow.core.command.TimerCommandResult;
import io.iworkflow.core.communication.InterStateChannelCommandResult;
import io.iworkflow.core.communication.SignalCommandResult;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommandResults", generator="Immutables")
@Immutable
public final class ImmutableCommandResults
extends CommandResults {
    private final ImmutableList<SignalCommandResult> allSignalCommandResults;
    private final ImmutableList<TimerCommandResult> allTimerCommandResults;
    private final ImmutableList<InterStateChannelCommandResult> allInterStateChannelCommandResult;
    @Nullable
    private final Boolean waitUntilApiSucceeded;

    private ImmutableCommandResults(ImmutableList<SignalCommandResult> allSignalCommandResults, ImmutableList<TimerCommandResult> allTimerCommandResults, ImmutableList<InterStateChannelCommandResult> allInterStateChannelCommandResult, @Nullable Boolean waitUntilApiSucceeded) {
        this.allSignalCommandResults = allSignalCommandResults;
        this.allTimerCommandResults = allTimerCommandResults;
        this.allInterStateChannelCommandResult = allInterStateChannelCommandResult;
        this.waitUntilApiSucceeded = waitUntilApiSucceeded;
    }

    public ImmutableList<SignalCommandResult> getAllSignalCommandResults() {
        return this.allSignalCommandResults;
    }

    public ImmutableList<TimerCommandResult> getAllTimerCommandResults() {
        return this.allTimerCommandResults;
    }

    public ImmutableList<InterStateChannelCommandResult> getAllInterStateChannelCommandResult() {
        return this.allInterStateChannelCommandResult;
    }

    @Override
    public Optional<Boolean> getWaitUntilApiSucceeded() {
        return Optional.ofNullable(this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withAllSignalCommandResults(SignalCommandResult ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommandResults((ImmutableList<SignalCommandResult>)newValue, this.allTimerCommandResults, this.allInterStateChannelCommandResult, this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withAllSignalCommandResults(Iterable<? extends SignalCommandResult> elements) {
        if (this.allSignalCommandResults == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommandResults((ImmutableList<SignalCommandResult>)newValue, this.allTimerCommandResults, this.allInterStateChannelCommandResult, this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withAllTimerCommandResults(TimerCommandResult ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommandResults(this.allSignalCommandResults, (ImmutableList<TimerCommandResult>)newValue, this.allInterStateChannelCommandResult, this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withAllTimerCommandResults(Iterable<? extends TimerCommandResult> elements) {
        if (this.allTimerCommandResults == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommandResults(this.allSignalCommandResults, (ImmutableList<TimerCommandResult>)newValue, this.allInterStateChannelCommandResult, this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withAllInterStateChannelCommandResult(InterStateChannelCommandResult ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommandResults(this.allSignalCommandResults, this.allTimerCommandResults, (ImmutableList<InterStateChannelCommandResult>)newValue, this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withAllInterStateChannelCommandResult(Iterable<? extends InterStateChannelCommandResult> elements) {
        if (this.allInterStateChannelCommandResult == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommandResults(this.allSignalCommandResults, this.allTimerCommandResults, (ImmutableList<InterStateChannelCommandResult>)newValue, this.waitUntilApiSucceeded);
    }

    public final ImmutableCommandResults withWaitUntilApiSucceeded(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.waitUntilApiSucceeded, newValue)) {
            return this;
        }
        return new ImmutableCommandResults(this.allSignalCommandResults, this.allTimerCommandResults, this.allInterStateChannelCommandResult, newValue);
    }

    public final ImmutableCommandResults withWaitUntilApiSucceeded(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.waitUntilApiSucceeded, value)) {
            return this;
        }
        return new ImmutableCommandResults(this.allSignalCommandResults, this.allTimerCommandResults, this.allInterStateChannelCommandResult, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommandResults && this.equalTo(0, (ImmutableCommandResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommandResults another) {
        return this.allSignalCommandResults.equals(another.allSignalCommandResults) && this.allTimerCommandResults.equals(another.allTimerCommandResults) && this.allInterStateChannelCommandResult.equals(another.allInterStateChannelCommandResult) && Objects.equals(this.waitUntilApiSucceeded, another.waitUntilApiSucceeded);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.allSignalCommandResults.hashCode();
        h += (h << 5) + this.allTimerCommandResults.hashCode();
        h += (h << 5) + this.allInterStateChannelCommandResult.hashCode();
        h += (h << 5) + Objects.hashCode(this.waitUntilApiSucceeded);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommandResults").omitNullValues().add("allSignalCommandResults", this.allSignalCommandResults).add("allTimerCommandResults", this.allTimerCommandResults).add("allInterStateChannelCommandResult", this.allInterStateChannelCommandResult).add("waitUntilApiSucceeded", (Object)this.waitUntilApiSucceeded).toString();
    }

    public static ImmutableCommandResults copyOf(CommandResults instance) {
        if (instance instanceof ImmutableCommandResults) {
            return (ImmutableCommandResults)instance;
        }
        return ImmutableCommandResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommandResults", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<SignalCommandResult> allSignalCommandResults = ImmutableList.builder();
        private ImmutableList.Builder<TimerCommandResult> allTimerCommandResults = ImmutableList.builder();
        private ImmutableList.Builder<InterStateChannelCommandResult> allInterStateChannelCommandResult = ImmutableList.builder();
        @Nullable
        private Boolean waitUntilApiSucceeded;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAllSignalCommandResults(instance.getAllSignalCommandResults());
            this.addAllAllTimerCommandResults(instance.getAllTimerCommandResults());
            this.addAllAllInterStateChannelCommandResult(instance.getAllInterStateChannelCommandResult());
            Optional<Boolean> waitUntilApiSucceededOptional = instance.getWaitUntilApiSucceeded();
            if (waitUntilApiSucceededOptional.isPresent()) {
                this.waitUntilApiSucceeded(waitUntilApiSucceededOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignalCommandResults(SignalCommandResult element) {
            this.allSignalCommandResults.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignalCommandResults(SignalCommandResult ... elements) {
            this.allSignalCommandResults.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allSignalCommandResults(Iterable<? extends SignalCommandResult> elements) {
            this.allSignalCommandResults = ImmutableList.builder();
            return this.addAllAllSignalCommandResults(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllSignalCommandResults(Iterable<? extends SignalCommandResult> elements) {
            this.allSignalCommandResults.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllTimerCommandResults(TimerCommandResult element) {
            this.allTimerCommandResults.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllTimerCommandResults(TimerCommandResult ... elements) {
            this.allTimerCommandResults.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allTimerCommandResults(Iterable<? extends TimerCommandResult> elements) {
            this.allTimerCommandResults = ImmutableList.builder();
            return this.addAllAllTimerCommandResults(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllTimerCommandResults(Iterable<? extends TimerCommandResult> elements) {
            this.allTimerCommandResults.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllInterStateChannelCommandResult(InterStateChannelCommandResult element) {
            this.allInterStateChannelCommandResult.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllInterStateChannelCommandResult(InterStateChannelCommandResult ... elements) {
            this.allInterStateChannelCommandResult.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder allInterStateChannelCommandResult(Iterable<? extends InterStateChannelCommandResult> elements) {
            this.allInterStateChannelCommandResult = ImmutableList.builder();
            return this.addAllAllInterStateChannelCommandResult(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAllInterStateChannelCommandResult(Iterable<? extends InterStateChannelCommandResult> elements) {
            this.allInterStateChannelCommandResult.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder waitUntilApiSucceeded(boolean waitUntilApiSucceeded) {
            this.waitUntilApiSucceeded = waitUntilApiSucceeded;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder waitUntilApiSucceeded(Optional<Boolean> waitUntilApiSucceeded) {
            this.waitUntilApiSucceeded = waitUntilApiSucceeded.orElse(null);
            return this;
        }

        public ImmutableCommandResults build() {
            return new ImmutableCommandResults(this.allSignalCommandResults.build(), this.allTimerCommandResults.build(), this.allInterStateChannelCommandResult.build(), this.waitUntilApiSucceeded);
        }
    }
}

