/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.command.BaseCommand;
import io.iworkflow.core.command.TimerCommand;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TimerCommand", generator="Immutables")
@Immutable
public final class ImmutableTimerCommand
extends TimerCommand {
    @Nullable
    private final String commandId;
    private final int firingUnixTimestampSeconds;

    private ImmutableTimerCommand(@Nullable String commandId, int firingUnixTimestampSeconds) {
        this.commandId = commandId;
        this.firingUnixTimestampSeconds = firingUnixTimestampSeconds;
    }

    @Override
    public Optional<String> getCommandId() {
        return Optional.ofNullable(this.commandId);
    }

    @Override
    public int getFiringUnixTimestampSeconds() {
        return this.firingUnixTimestampSeconds;
    }

    public final ImmutableTimerCommand withCommandId(String value) {
        String newValue = Objects.requireNonNull(value, "commandId");
        if (Objects.equals(this.commandId, newValue)) {
            return this;
        }
        return new ImmutableTimerCommand(newValue, this.firingUnixTimestampSeconds);
    }

    public final ImmutableTimerCommand withCommandId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commandId, value)) {
            return this;
        }
        return new ImmutableTimerCommand(value, this.firingUnixTimestampSeconds);
    }

    public final ImmutableTimerCommand withFiringUnixTimestampSeconds(int value) {
        if (this.firingUnixTimestampSeconds == value) {
            return this;
        }
        return new ImmutableTimerCommand(this.commandId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimerCommand && this.equalTo(0, (ImmutableTimerCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableTimerCommand another) {
        return Objects.equals(this.commandId, another.commandId) && this.firingUnixTimestampSeconds == another.firingUnixTimestampSeconds;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.commandId);
        h += (h << 5) + this.firingUnixTimestampSeconds;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TimerCommand").omitNullValues().add("commandId", (Object)this.commandId).add("firingUnixTimestampSeconds", this.firingUnixTimestampSeconds).toString();
    }

    public static ImmutableTimerCommand copyOf(TimerCommand instance) {
        if (instance instanceof ImmutableTimerCommand) {
            return (ImmutableTimerCommand)instance;
        }
        return ImmutableTimerCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimerCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FIRING_UNIX_TIMESTAMP_SECONDS = 1L;
        private long initBits = 1L;
        @Nullable
        private String commandId;
        private int firingUnixTimestampSeconds;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TimerCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseCommand instance;
            Optional<String> commandIdOptional;
            if (object instanceof BaseCommand && (commandIdOptional = (instance = (BaseCommand)object).getCommandId()).isPresent()) {
                this.commandId(commandIdOptional);
            }
            if (object instanceof TimerCommand) {
                instance = (TimerCommand)object;
                this.firingUnixTimestampSeconds(((TimerCommand)instance).getFiringUnixTimestampSeconds());
            }
        }

        @CanIgnoreReturnValue
        public final Builder commandId(String commandId) {
            this.commandId = Objects.requireNonNull(commandId, "commandId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandId(Optional<String> commandId) {
            this.commandId = commandId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder firingUnixTimestampSeconds(int firingUnixTimestampSeconds) {
            this.firingUnixTimestampSeconds = firingUnixTimestampSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTimerCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTimerCommand(this.commandId, this.firingUnixTimestampSeconds);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("firingUnixTimestampSeconds");
            }
            return "Cannot build TimerCommand, some of required attributes are not set " + attributes;
        }
    }
}

