/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.command.TimerCommandResult;
import io.iworkflow.gen.models.TimerStatus;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TimerCommandResult", generator="Immutables")
@Immutable
public final class ImmutableTimerCommandResult
extends TimerCommandResult {
    private final TimerStatus timerStatus;
    private final String commandId;

    private ImmutableTimerCommandResult(TimerStatus timerStatus, String commandId) {
        this.timerStatus = timerStatus;
        this.commandId = commandId;
    }

    @Override
    public TimerStatus getTimerStatus() {
        return this.timerStatus;
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    public final ImmutableTimerCommandResult withTimerStatus(TimerStatus value) {
        TimerStatus newValue = Objects.requireNonNull(value, "timerStatus");
        if (this.timerStatus == newValue) {
            return this;
        }
        return new ImmutableTimerCommandResult(newValue, this.commandId);
    }

    public final ImmutableTimerCommandResult withCommandId(String value) {
        String newValue = Objects.requireNonNull(value, "commandId");
        if (this.commandId.equals(newValue)) {
            return this;
        }
        return new ImmutableTimerCommandResult(this.timerStatus, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimerCommandResult && this.equalTo(0, (ImmutableTimerCommandResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableTimerCommandResult another) {
        return this.timerStatus.equals((Object)another.timerStatus) && this.commandId.equals(another.commandId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.timerStatus.hashCode();
        h += (h << 5) + this.commandId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TimerCommandResult").omitNullValues().add("timerStatus", (Object)this.timerStatus).add("commandId", (Object)this.commandId).toString();
    }

    public static ImmutableTimerCommandResult copyOf(TimerCommandResult instance) {
        if (instance instanceof ImmutableTimerCommandResult) {
            return (ImmutableTimerCommandResult)instance;
        }
        return ImmutableTimerCommandResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimerCommandResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIMER_STATUS = 1L;
        private static final long INIT_BIT_COMMAND_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private TimerStatus timerStatus;
        @Nullable
        private String commandId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TimerCommandResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.timerStatus(instance.getTimerStatus());
            this.commandId(instance.getCommandId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timerStatus(TimerStatus timerStatus) {
            this.timerStatus = Objects.requireNonNull(timerStatus, "timerStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandId(String commandId) {
            this.commandId = Objects.requireNonNull(commandId, "commandId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTimerCommandResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTimerCommandResult(this.timerStatus, this.commandId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timerStatus");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commandId");
            }
            return "Cannot build TimerCommandResult, some of required attributes are not set " + attributes;
        }
    }
}

