/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.command;

import io.iworkflow.core.command.BaseCommand;
import io.iworkflow.core.command.ImmutableTimerCommand;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TimerCommand
implements BaseCommand {
    public abstract int getFiringUnixTimestampSeconds();

    public static TimerCommand createByDuration(String commandId, Duration duration) {
        return ImmutableTimerCommand.builder().commandId(commandId).firingUnixTimestampSeconds((int)(System.currentTimeMillis() / 1000L + duration.getSeconds())).build();
    }

    public static TimerCommand createByDuration(Duration duration) {
        return ImmutableTimerCommand.builder().firingUnixTimestampSeconds((int)(System.currentTimeMillis() / 1000L + duration.getSeconds())).build();
    }
}

