/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import io.iworkflow.core.ObjectEncoder;
import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.communication.Communication;
import io.iworkflow.gen.models.EncodedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommunicationImpl
implements Communication {
    final Map<String, Class<?>> nameToTypeMap;
    final Map<String, List<EncodedObject>> toPublish = new HashMap<String, List<EncodedObject>>();
    final ObjectEncoder objectEncoder;

    public CommunicationImpl(Map<String, Class<?>> nameToTypeMap, ObjectEncoder objectEncoder) {
        this.nameToTypeMap = nameToTypeMap;
        this.objectEncoder = objectEncoder;
    }

    @Override
    public void publishInterstateChannel(String channelName, Object value) {
        Class<?> type = this.nameToTypeMap.get(channelName);
        if (!type.isInstance(value)) {
            throw new WorkflowDefinitionException(String.format("InterStateChannel value is not of type %s", type.getName()));
        }
        List publish = this.toPublish.computeIfAbsent(channelName, s -> new ArrayList());
        publish.add(this.objectEncoder.encode(value));
    }

    public Map<String, List<EncodedObject>> getToPublishInterStateChannels() {
        return this.toPublish;
    }
}

