/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.command.BaseCommand;
import io.iworkflow.core.communication.InterStateChannelCommand;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InterStateChannelCommand", generator="Immutables")
@Immutable
public final class ImmutableInterStateChannelCommand
extends InterStateChannelCommand {
    @Nullable
    private final String commandId;
    private final String channelName;

    private ImmutableInterStateChannelCommand(@Nullable String commandId, String channelName) {
        this.commandId = commandId;
        this.channelName = channelName;
    }

    @Override
    public Optional<String> getCommandId() {
        return Optional.ofNullable(this.commandId);
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    public final ImmutableInterStateChannelCommand withCommandId(String value) {
        String newValue = Objects.requireNonNull(value, "commandId");
        if (Objects.equals(this.commandId, newValue)) {
            return this;
        }
        return new ImmutableInterStateChannelCommand(newValue, this.channelName);
    }

    public final ImmutableInterStateChannelCommand withCommandId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commandId, value)) {
            return this;
        }
        return new ImmutableInterStateChannelCommand(value, this.channelName);
    }

    public final ImmutableInterStateChannelCommand withChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "channelName");
        if (this.channelName.equals(newValue)) {
            return this;
        }
        return new ImmutableInterStateChannelCommand(this.commandId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInterStateChannelCommand && this.equalTo(0, (ImmutableInterStateChannelCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableInterStateChannelCommand another) {
        return Objects.equals(this.commandId, another.commandId) && this.channelName.equals(another.channelName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.commandId);
        h += (h << 5) + this.channelName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InterStateChannelCommand").omitNullValues().add("commandId", (Object)this.commandId).add("channelName", (Object)this.channelName).toString();
    }

    public static ImmutableInterStateChannelCommand copyOf(InterStateChannelCommand instance) {
        if (instance instanceof ImmutableInterStateChannelCommand) {
            return (ImmutableInterStateChannelCommand)instance;
        }
        return ImmutableInterStateChannelCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InterStateChannelCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String commandId;
        @Nullable
        private String channelName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(InterStateChannelCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseCommand instance;
            Optional<String> commandIdOptional;
            if (object instanceof BaseCommand && (commandIdOptional = (instance = (BaseCommand)object).getCommandId()).isPresent()) {
                this.commandId(commandIdOptional);
            }
            if (object instanceof InterStateChannelCommand) {
                instance = (InterStateChannelCommand)object;
                this.channelName(((InterStateChannelCommand)instance).getChannelName());
            }
        }

        @CanIgnoreReturnValue
        public final Builder commandId(String commandId) {
            this.commandId = Objects.requireNonNull(commandId, "commandId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandId(Optional<String> commandId) {
            this.commandId = commandId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelName(String channelName) {
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInterStateChannelCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInterStateChannelCommand(this.commandId, this.channelName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelName");
            }
            return "Cannot build InterStateChannelCommand, some of required attributes are not set " + attributes;
        }
    }
}

