/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.communication.InterStateChannelCommandResult;
import io.iworkflow.gen.models.ChannelRequestStatus;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InterStateChannelCommandResult", generator="Immutables")
@Immutable
public final class ImmutableInterStateChannelCommandResult
extends InterStateChannelCommandResult {
    private final String commandId;
    private final String channelName;
    @Nullable
    private final Object value;
    private final ChannelRequestStatus requestStatusEnum;

    private ImmutableInterStateChannelCommandResult(String commandId, String channelName, @Nullable Object value, ChannelRequestStatus requestStatusEnum) {
        this.commandId = commandId;
        this.channelName = channelName;
        this.value = value;
        this.requestStatusEnum = requestStatusEnum;
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public Optional<Object> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public ChannelRequestStatus getRequestStatusEnum() {
        return this.requestStatusEnum;
    }

    public final ImmutableInterStateChannelCommandResult withCommandId(String value) {
        String newValue = Objects.requireNonNull(value, "commandId");
        if (this.commandId.equals(newValue)) {
            return this;
        }
        return new ImmutableInterStateChannelCommandResult(newValue, this.channelName, this.value, this.requestStatusEnum);
    }

    public final ImmutableInterStateChannelCommandResult withChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "channelName");
        if (this.channelName.equals(newValue)) {
            return this;
        }
        return new ImmutableInterStateChannelCommandResult(this.commandId, newValue, this.value, this.requestStatusEnum);
    }

    public final ImmutableInterStateChannelCommandResult withValue(Object value) {
        Object newValue = Objects.requireNonNull(value, "value");
        if (this.value == newValue) {
            return this;
        }
        return new ImmutableInterStateChannelCommandResult(this.commandId, this.channelName, newValue, this.requestStatusEnum);
    }

    public final ImmutableInterStateChannelCommandResult withValue(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.value == value) {
            return this;
        }
        return new ImmutableInterStateChannelCommandResult(this.commandId, this.channelName, value, this.requestStatusEnum);
    }

    public final ImmutableInterStateChannelCommandResult withRequestStatusEnum(ChannelRequestStatus value) {
        ChannelRequestStatus newValue = Objects.requireNonNull(value, "requestStatusEnum");
        if (this.requestStatusEnum == newValue) {
            return this;
        }
        return new ImmutableInterStateChannelCommandResult(this.commandId, this.channelName, this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInterStateChannelCommandResult && this.equalTo(0, (ImmutableInterStateChannelCommandResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableInterStateChannelCommandResult another) {
        return this.commandId.equals(another.commandId) && this.channelName.equals(another.channelName) && Objects.equals(this.value, another.value) && this.requestStatusEnum.equals((Object)another.requestStatusEnum);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commandId.hashCode();
        h += (h << 5) + this.channelName.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + this.requestStatusEnum.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InterStateChannelCommandResult").omitNullValues().add("commandId", (Object)this.commandId).add("channelName", (Object)this.channelName).add("value", this.value).add("requestStatusEnum", (Object)this.requestStatusEnum).toString();
    }

    public static ImmutableInterStateChannelCommandResult copyOf(InterStateChannelCommandResult instance) {
        if (instance instanceof ImmutableInterStateChannelCommandResult) {
            return (ImmutableInterStateChannelCommandResult)instance;
        }
        return ImmutableInterStateChannelCommandResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InterStateChannelCommandResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMAND_ID = 1L;
        private static final long INIT_BIT_CHANNEL_NAME = 2L;
        private static final long INIT_BIT_REQUEST_STATUS_ENUM = 4L;
        private long initBits = 7L;
        @Nullable
        private String commandId;
        @Nullable
        private String channelName;
        @Nullable
        private Object value;
        @Nullable
        private ChannelRequestStatus requestStatusEnum;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InterStateChannelCommandResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.commandId(instance.getCommandId());
            this.channelName(instance.getChannelName());
            Optional<Object> valueOptional = instance.getValue();
            if (valueOptional.isPresent()) {
                this.value(valueOptional);
            }
            this.requestStatusEnum(instance.getRequestStatusEnum());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandId(String commandId) {
            this.commandId = Objects.requireNonNull(commandId, "commandId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelName(String channelName) {
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Object value) {
            this.value = Objects.requireNonNull(value, "value");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Optional<? extends Object> value) {
            this.value = value.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestStatusEnum(ChannelRequestStatus requestStatusEnum) {
            this.requestStatusEnum = Objects.requireNonNull(requestStatusEnum, "requestStatusEnum");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableInterStateChannelCommandResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInterStateChannelCommandResult(this.commandId, this.channelName, this.value, this.requestStatusEnum);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commandId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channelName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("requestStatusEnum");
            }
            return "Cannot build InterStateChannelCommandResult, some of required attributes are not set " + attributes;
        }
    }
}

