/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.communication.InterStateChannelDef;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InterStateChannelDef", generator="Immutables")
@Immutable
public final class ImmutableInterStateChannelDef
extends InterStateChannelDef {
    private final Class valueType;
    private final String channelName;

    private ImmutableInterStateChannelDef(Class valueType, String channelName) {
        this.valueType = valueType;
        this.channelName = channelName;
    }

    @Override
    public Class getValueType() {
        return this.valueType;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    public final ImmutableInterStateChannelDef withValueType(Class value) {
        if (this.valueType == value) {
            return this;
        }
        Class newValue = Objects.requireNonNull(value, "valueType");
        return new ImmutableInterStateChannelDef(newValue, this.channelName);
    }

    public final ImmutableInterStateChannelDef withChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "channelName");
        if (this.channelName.equals(newValue)) {
            return this;
        }
        return new ImmutableInterStateChannelDef(this.valueType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInterStateChannelDef && this.equalTo(0, (ImmutableInterStateChannelDef)another);
    }

    private boolean equalTo(int synthetic, ImmutableInterStateChannelDef another) {
        return this.valueType.equals(another.valueType) && this.channelName.equals(another.channelName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.valueType.hashCode();
        h += (h << 5) + this.channelName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InterStateChannelDef").omitNullValues().add("valueType", (Object)this.valueType).add("channelName", (Object)this.channelName).toString();
    }

    public static ImmutableInterStateChannelDef copyOf(InterStateChannelDef instance) {
        if (instance instanceof ImmutableInterStateChannelDef) {
            return (ImmutableInterStateChannelDef)instance;
        }
        return ImmutableInterStateChannelDef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InterStateChannelDef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private Class valueType;
        @Nullable
        private String channelName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InterStateChannelDef instance) {
            Objects.requireNonNull(instance, "instance");
            this.valueType(instance.getValueType());
            this.channelName(instance.getChannelName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueType(Class valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelName(String channelName) {
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInterStateChannelDef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInterStateChannelDef(this.valueType, this.channelName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("valueType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channelName");
            }
            return "Cannot build InterStateChannelDef, some of required attributes are not set " + attributes;
        }
    }
}

