/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.communication.SignalChannelDef;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SignalChannelDef", generator="Immutables")
@Immutable
public final class ImmutableSignalChannelDef
extends SignalChannelDef {
    private final Class signalValueType;
    private final String signalChannelName;

    private ImmutableSignalChannelDef(Class signalValueType, String signalChannelName) {
        this.signalValueType = signalValueType;
        this.signalChannelName = signalChannelName;
    }

    @Override
    public Class getSignalValueType() {
        return this.signalValueType;
    }

    @Override
    public String getSignalChannelName() {
        return this.signalChannelName;
    }

    public final ImmutableSignalChannelDef withSignalValueType(Class value) {
        if (this.signalValueType == value) {
            return this;
        }
        Class newValue = Objects.requireNonNull(value, "signalValueType");
        return new ImmutableSignalChannelDef(newValue, this.signalChannelName);
    }

    public final ImmutableSignalChannelDef withSignalChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "signalChannelName");
        if (this.signalChannelName.equals(newValue)) {
            return this;
        }
        return new ImmutableSignalChannelDef(this.signalValueType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignalChannelDef && this.equalTo(0, (ImmutableSignalChannelDef)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignalChannelDef another) {
        return this.signalValueType.equals(another.signalValueType) && this.signalChannelName.equals(another.signalChannelName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.signalValueType.hashCode();
        h += (h << 5) + this.signalChannelName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SignalChannelDef").omitNullValues().add("signalValueType", (Object)this.signalValueType).add("signalChannelName", (Object)this.signalChannelName).toString();
    }

    public static ImmutableSignalChannelDef copyOf(SignalChannelDef instance) {
        if (instance instanceof ImmutableSignalChannelDef) {
            return (ImmutableSignalChannelDef)instance;
        }
        return ImmutableSignalChannelDef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SignalChannelDef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNAL_VALUE_TYPE = 1L;
        private static final long INIT_BIT_SIGNAL_CHANNEL_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private Class signalValueType;
        @Nullable
        private String signalChannelName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SignalChannelDef instance) {
            Objects.requireNonNull(instance, "instance");
            this.signalValueType(instance.getSignalValueType());
            this.signalChannelName(instance.getSignalChannelName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalValueType(Class signalValueType) {
            this.signalValueType = Objects.requireNonNull(signalValueType, "signalValueType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalChannelName(String signalChannelName) {
            this.signalChannelName = Objects.requireNonNull(signalChannelName, "signalChannelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSignalChannelDef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignalChannelDef(this.signalValueType, this.signalChannelName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signalValueType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signalChannelName");
            }
            return "Cannot build SignalChannelDef, some of required attributes are not set " + attributes;
        }
    }
}

