/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.command.BaseCommand;
import io.iworkflow.core.communication.SignalCommand;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SignalCommand", generator="Immutables")
@Immutable
public final class ImmutableSignalCommand
extends SignalCommand {
    @Nullable
    private final String commandId;
    private final String signalChannelName;

    private ImmutableSignalCommand(@Nullable String commandId, String signalChannelName) {
        this.commandId = commandId;
        this.signalChannelName = signalChannelName;
    }

    @Override
    public Optional<String> getCommandId() {
        return Optional.ofNullable(this.commandId);
    }

    @Override
    public String getSignalChannelName() {
        return this.signalChannelName;
    }

    public final ImmutableSignalCommand withCommandId(String value) {
        String newValue = Objects.requireNonNull(value, "commandId");
        if (Objects.equals(this.commandId, newValue)) {
            return this;
        }
        return new ImmutableSignalCommand(newValue, this.signalChannelName);
    }

    public final ImmutableSignalCommand withCommandId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.commandId, value)) {
            return this;
        }
        return new ImmutableSignalCommand(value, this.signalChannelName);
    }

    public final ImmutableSignalCommand withSignalChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "signalChannelName");
        if (this.signalChannelName.equals(newValue)) {
            return this;
        }
        return new ImmutableSignalCommand(this.commandId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignalCommand && this.equalTo(0, (ImmutableSignalCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignalCommand another) {
        return Objects.equals(this.commandId, another.commandId) && this.signalChannelName.equals(another.signalChannelName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.commandId);
        h += (h << 5) + this.signalChannelName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SignalCommand").omitNullValues().add("commandId", (Object)this.commandId).add("signalChannelName", (Object)this.signalChannelName).toString();
    }

    public static ImmutableSignalCommand copyOf(SignalCommand instance) {
        if (instance instanceof ImmutableSignalCommand) {
            return (ImmutableSignalCommand)instance;
        }
        return ImmutableSignalCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SignalCommand", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNAL_CHANNEL_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String commandId;
        @Nullable
        private String signalChannelName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SignalCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> commandIdOptional;
            BaseCommand instance;
            if (object instanceof SignalCommand) {
                instance = (SignalCommand)object;
                this.signalChannelName(((SignalCommand)instance).getSignalChannelName());
            }
            if (object instanceof BaseCommand && (commandIdOptional = (instance = (BaseCommand)object).getCommandId()).isPresent()) {
                this.commandId(commandIdOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder commandId(String commandId) {
            this.commandId = Objects.requireNonNull(commandId, "commandId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandId(Optional<String> commandId) {
            this.commandId = commandId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalChannelName(String signalChannelName) {
            this.signalChannelName = Objects.requireNonNull(signalChannelName, "signalChannelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSignalCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignalCommand(this.commandId, this.signalChannelName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signalChannelName");
            }
            return "Cannot build SignalCommand, some of required attributes are not set " + attributes;
        }
    }
}

