/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.communication;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.communication.SignalCommandResult;
import io.iworkflow.gen.models.ChannelRequestStatus;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SignalCommandResult", generator="Immutables")
@Immutable
public final class ImmutableSignalCommandResult
extends SignalCommandResult {
    private final String commandId;
    private final String signalChannelName;
    @Nullable
    private final Object signalValue;
    private final ChannelRequestStatus signalRequestStatusEnum;

    private ImmutableSignalCommandResult(String commandId, String signalChannelName, @Nullable Object signalValue, ChannelRequestStatus signalRequestStatusEnum) {
        this.commandId = commandId;
        this.signalChannelName = signalChannelName;
        this.signalValue = signalValue;
        this.signalRequestStatusEnum = signalRequestStatusEnum;
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    @Override
    public String getSignalChannelName() {
        return this.signalChannelName;
    }

    @Override
    public Optional<Object> getSignalValue() {
        return Optional.ofNullable(this.signalValue);
    }

    @Override
    public ChannelRequestStatus getSignalRequestStatusEnum() {
        return this.signalRequestStatusEnum;
    }

    public final ImmutableSignalCommandResult withCommandId(String value) {
        String newValue = Objects.requireNonNull(value, "commandId");
        if (this.commandId.equals(newValue)) {
            return this;
        }
        return new ImmutableSignalCommandResult(newValue, this.signalChannelName, this.signalValue, this.signalRequestStatusEnum);
    }

    public final ImmutableSignalCommandResult withSignalChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "signalChannelName");
        if (this.signalChannelName.equals(newValue)) {
            return this;
        }
        return new ImmutableSignalCommandResult(this.commandId, newValue, this.signalValue, this.signalRequestStatusEnum);
    }

    public final ImmutableSignalCommandResult withSignalValue(Object value) {
        Object newValue = Objects.requireNonNull(value, "signalValue");
        if (this.signalValue == newValue) {
            return this;
        }
        return new ImmutableSignalCommandResult(this.commandId, this.signalChannelName, newValue, this.signalRequestStatusEnum);
    }

    public final ImmutableSignalCommandResult withSignalValue(Optional<? extends Object> optional) {
        Object value = optional.orElse(null);
        if (this.signalValue == value) {
            return this;
        }
        return new ImmutableSignalCommandResult(this.commandId, this.signalChannelName, value, this.signalRequestStatusEnum);
    }

    public final ImmutableSignalCommandResult withSignalRequestStatusEnum(ChannelRequestStatus value) {
        ChannelRequestStatus newValue = Objects.requireNonNull(value, "signalRequestStatusEnum");
        if (this.signalRequestStatusEnum == newValue) {
            return this;
        }
        return new ImmutableSignalCommandResult(this.commandId, this.signalChannelName, this.signalValue, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignalCommandResult && this.equalTo(0, (ImmutableSignalCommandResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignalCommandResult another) {
        return this.commandId.equals(another.commandId) && this.signalChannelName.equals(another.signalChannelName) && Objects.equals(this.signalValue, another.signalValue) && this.signalRequestStatusEnum.equals((Object)another.signalRequestStatusEnum);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commandId.hashCode();
        h += (h << 5) + this.signalChannelName.hashCode();
        h += (h << 5) + Objects.hashCode(this.signalValue);
        h += (h << 5) + this.signalRequestStatusEnum.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SignalCommandResult").omitNullValues().add("commandId", (Object)this.commandId).add("signalChannelName", (Object)this.signalChannelName).add("signalValue", this.signalValue).add("signalRequestStatusEnum", (Object)this.signalRequestStatusEnum).toString();
    }

    public static ImmutableSignalCommandResult copyOf(SignalCommandResult instance) {
        if (instance instanceof ImmutableSignalCommandResult) {
            return (ImmutableSignalCommandResult)instance;
        }
        return ImmutableSignalCommandResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SignalCommandResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMAND_ID = 1L;
        private static final long INIT_BIT_SIGNAL_CHANNEL_NAME = 2L;
        private static final long INIT_BIT_SIGNAL_REQUEST_STATUS_ENUM = 4L;
        private long initBits = 7L;
        @Nullable
        private String commandId;
        @Nullable
        private String signalChannelName;
        @Nullable
        private Object signalValue;
        @Nullable
        private ChannelRequestStatus signalRequestStatusEnum;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SignalCommandResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.commandId(instance.getCommandId());
            this.signalChannelName(instance.getSignalChannelName());
            Optional<Object> signalValueOptional = instance.getSignalValue();
            if (signalValueOptional.isPresent()) {
                this.signalValue(signalValueOptional);
            }
            this.signalRequestStatusEnum(instance.getSignalRequestStatusEnum());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandId(String commandId) {
            this.commandId = Objects.requireNonNull(commandId, "commandId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalChannelName(String signalChannelName) {
            this.signalChannelName = Objects.requireNonNull(signalChannelName, "signalChannelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalValue(Object signalValue) {
            this.signalValue = Objects.requireNonNull(signalValue, "signalValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalValue(Optional<? extends Object> signalValue) {
            this.signalValue = signalValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signalRequestStatusEnum(ChannelRequestStatus signalRequestStatusEnum) {
            this.signalRequestStatusEnum = Objects.requireNonNull(signalRequestStatusEnum, "signalRequestStatusEnum");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSignalCommandResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignalCommandResult(this.commandId, this.signalChannelName, this.signalValue, this.signalRequestStatusEnum);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commandId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signalChannelName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signalRequestStatusEnum");
            }
            return "Cannot build SignalCommandResult, some of required attributes are not set " + attributes;
        }
    }
}

