/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.persistence;

import io.iworkflow.core.ObjectEncoder;
import io.iworkflow.core.persistence.DataAttributesRW;
import io.iworkflow.gen.models.EncodedObject;
import io.iworkflow.gen.models.KeyValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataAttributesRWImpl
implements DataAttributesRW {
    private final Map<String, Class<?>> keyToTypeMap;
    private final Map<String, EncodedObject> keyToEncodedObjectMap;
    private final Map<String, EncodedObject> toReturnToServer;
    private final ObjectEncoder objectEncoder;

    public DataAttributesRWImpl(Map<String, Class<?>> keyToTypeMap, Map<String, EncodedObject> keyToValueMap, ObjectEncoder objectEncoder) {
        this.keyToTypeMap = keyToTypeMap;
        this.keyToEncodedObjectMap = keyToValueMap;
        this.toReturnToServer = new HashMap<String, EncodedObject>();
        this.objectEncoder = objectEncoder;
    }

    @Override
    public <T> T getDataAttribute(String key, Class<T> type) {
        if (!this.keyToTypeMap.containsKey(key)) {
            throw new IllegalArgumentException(String.format("data attribute %s is not registered", key));
        }
        if (!this.keyToEncodedObjectMap.containsKey(key)) {
            return null;
        }
        Class<?> registeredType = this.keyToTypeMap.get(key);
        if (!type.isAssignableFrom(registeredType)) {
            throw new IllegalArgumentException(String.format("registered type %s is not assignable from %s", registeredType.getName(), type.getName()));
        }
        return type.cast(this.objectEncoder.decode(this.keyToEncodedObjectMap.get(key), registeredType));
    }

    @Override
    public void setDataAttribute(String key, Object value) {
        if (!this.keyToTypeMap.containsKey(key)) {
            throw new IllegalArgumentException(String.format("data attribute %s is not registered", key));
        }
        Class<?> registeredType = this.keyToTypeMap.get(key);
        if (!registeredType.isInstance(value)) {
            throw new IllegalArgumentException(String.format("Input is not an instance of class %s", registeredType.getName()));
        }
        this.keyToEncodedObjectMap.put(key, this.objectEncoder.encode(value));
        this.toReturnToServer.put(key, this.objectEncoder.encode(value));
    }

    public List<KeyValue> getToReturnToServer() {
        return this.toReturnToServer.entrySet().stream().map(stringEncodedObjectEntry -> new KeyValue().key((String)stringEncodedObjectEntry.getKey()).value((EncodedObject)stringEncodedObjectEntry.getValue())).collect(Collectors.toList());
    }
}

