/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.persistence;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.iworkflow.core.persistence.PersistenceFieldDef;
import io.iworkflow.core.persistence.SearchAttributeDef;
import io.iworkflow.gen.models.SearchAttributeValueType;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SearchAttributeDef", generator="Immutables")
@Immutable
public final class ImmutableSearchAttributeDef
extends SearchAttributeDef {
    private final String key;
    private final SearchAttributeValueType searchAttributeType;

    private ImmutableSearchAttributeDef(String key, SearchAttributeValueType searchAttributeType) {
        this.key = key;
        this.searchAttributeType = searchAttributeType;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public SearchAttributeValueType getSearchAttributeType() {
        return this.searchAttributeType;
    }

    public final ImmutableSearchAttributeDef withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableSearchAttributeDef(newValue, this.searchAttributeType);
    }

    public final ImmutableSearchAttributeDef withSearchAttributeType(SearchAttributeValueType value) {
        SearchAttributeValueType newValue = Objects.requireNonNull(value, "searchAttributeType");
        if (this.searchAttributeType == newValue) {
            return this;
        }
        return new ImmutableSearchAttributeDef(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchAttributeDef && this.equalTo(0, (ImmutableSearchAttributeDef)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchAttributeDef another) {
        return this.key.equals(another.key) && this.searchAttributeType.equals((Object)another.searchAttributeType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.searchAttributeType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SearchAttributeDef").omitNullValues().add("key", (Object)this.key).add("searchAttributeType", (Object)this.searchAttributeType).toString();
    }

    public static ImmutableSearchAttributeDef copyOf(SearchAttributeDef instance) {
        if (instance instanceof ImmutableSearchAttributeDef) {
            return (ImmutableSearchAttributeDef)instance;
        }
        return ImmutableSearchAttributeDef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SearchAttributeDef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_SEARCH_ATTRIBUTE_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String key;
        @Nullable
        private SearchAttributeValueType searchAttributeType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SearchAttributeDef instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PersistenceFieldDef instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PersistenceFieldDef instance;
            if (object instanceof SearchAttributeDef) {
                instance = (SearchAttributeDef)object;
                this.searchAttributeType(((SearchAttributeDef)instance).getSearchAttributeType());
            }
            if (object instanceof PersistenceFieldDef) {
                instance = (PersistenceFieldDef)object;
                this.key(instance.getKey());
            }
        }

        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder searchAttributeType(SearchAttributeValueType searchAttributeType) {
            this.searchAttributeType = Objects.requireNonNull(searchAttributeType, "searchAttributeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSearchAttributeDef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchAttributeDef(this.key, this.searchAttributeType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("searchAttributeType");
            }
            return "Cannot build SearchAttributeDef, some of required attributes are not set " + attributes;
        }
    }
}

