/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.persistence;

import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.persistence.SearchAttributesRW;
import io.iworkflow.gen.models.SearchAttribute;
import io.iworkflow.gen.models.SearchAttributeValueType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchAttributeRWImpl
implements SearchAttributesRW {
    private final Map<String, SearchAttributeValueType> keyToTypeMap;
    private final Map<String, Long> int64AttributeMap;
    private final Map<String, Long> upsertToServerInt64AttributeMap;
    private final Map<String, String> stringAttributeMap;
    private final Map<String, String> upsertToServerStringAttributeMap;
    private final Map<String, Double> doubleAttributeMap = new HashMap<String, Double>();
    private final Map<String, Double> upsertToServerDoubleAttributeMap = new HashMap<String, Double>();
    private final Map<String, Boolean> boolAttributeMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> upsertToServerBoolAttributeMap = new HashMap<String, Boolean>();
    private final Map<String, List<String>> stringArrayAttributeMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> upsertToServerStringArrayAttributeMap = new HashMap<String, List<String>>();

    public SearchAttributeRWImpl(Map<String, SearchAttributeValueType> keyToTypeMap, List<SearchAttribute> searchAttributeMap) {
        this.keyToTypeMap = keyToTypeMap;
        this.int64AttributeMap = new HashMap<String, Long>();
        this.upsertToServerInt64AttributeMap = new HashMap<String, Long>();
        this.stringAttributeMap = new HashMap<String, String>();
        this.upsertToServerStringAttributeMap = new HashMap<String, String>();
        if (searchAttributeMap != null) {
            searchAttributeMap.forEach(sa -> {
                SearchAttributeValueType type = (SearchAttributeValueType)((Object)((Object)keyToTypeMap.get(sa.getKey())));
                switch (type) {
                    case KEYWORD: 
                    case DATETIME: 
                    case TEXT: {
                        this.stringAttributeMap.put(sa.getKey(), sa.getStringValue());
                        break;
                    }
                    case INT: {
                        this.int64AttributeMap.put(sa.getKey(), sa.getIntegerValue());
                        break;
                    }
                    case BOOL: {
                        this.boolAttributeMap.put(sa.getKey(), sa.getBoolValue());
                        break;
                    }
                    case KEYWORD_ARRAY: {
                        this.stringArrayAttributeMap.put(sa.getKey(), sa.getStringArrayValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("empty search attribute value type shouldn't exist");
                    }
                }
            });
        }
    }

    @Override
    public Long getSearchAttributeInt64(String key) {
        return this.int64AttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeInt64(String key, Long value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.INT) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as int64", key));
        }
        this.int64AttributeMap.put(key, value);
        this.upsertToServerInt64AttributeMap.put(key, value);
    }

    @Override
    public Double getSearchAttributeDouble(String key) {
        return this.doubleAttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeDouble(String key, Double value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.DOUBLE) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as double", key));
        }
        this.doubleAttributeMap.put(key, value);
        this.upsertToServerDoubleAttributeMap.put(key, value);
    }

    @Override
    public Boolean getSearchAttributeBoolean(String key) {
        return this.boolAttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeBoolean(String key, Boolean value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.BOOL) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as bool", key));
        }
        this.boolAttributeMap.put(key, value);
        this.upsertToServerBoolAttributeMap.put(key, value);
    }

    @Override
    public String getSearchAttributeKeyword(String key) {
        return this.stringAttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeKeyword(String key, String value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.KEYWORD) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as keyword", key));
        }
        this.stringAttributeMap.put(key, value);
        this.upsertToServerStringAttributeMap.put(key, value);
    }

    @Override
    public String getSearchAttributeText(String key) {
        return this.stringAttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeText(String key, String value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.TEXT) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as Text", key));
        }
        this.stringAttributeMap.put(key, value);
        this.upsertToServerStringAttributeMap.put(key, value);
    }

    @Override
    public String getSearchAttributeDatetime(String key) {
        return this.stringAttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeDatetime(String key, String value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.DATETIME) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as datetime", key));
        }
        this.stringAttributeMap.put(key, value);
        this.upsertToServerStringAttributeMap.put(key, value);
    }

    @Override
    public List<String> getSearchAttributeKeywordArray(String key) {
        return this.stringArrayAttributeMap.get(key);
    }

    @Override
    public void setSearchAttributeKeywordArray(String key, List<String> value) {
        if (!this.keyToTypeMap.containsKey(key) || this.keyToTypeMap.get(key) != SearchAttributeValueType.KEYWORD_ARRAY) {
            throw new WorkflowDefinitionException(String.format("key %s is not defined as keyword array", key));
        }
        this.stringArrayAttributeMap.put(key, value);
        this.upsertToServerStringArrayAttributeMap.put(key, value);
    }

    public Map<String, Long> getUpsertToServerInt64AttributeMap() {
        return this.upsertToServerInt64AttributeMap;
    }

    public Map<String, String> getUpsertToServerStringAttributeMap() {
        return this.upsertToServerStringAttributeMap;
    }

    public Map<String, List<String>> getUpsertToServerStringArrayAttributeMap() {
        return this.upsertToServerStringArrayAttributeMap;
    }

    public Map<String, Boolean> getUpsertToServerBooleanAttributeMap() {
        return this.upsertToServerBoolAttributeMap;
    }

    public Map<String, Double> getUpsertToServerDoubleAttributeMap() {
        return this.upsertToServerDoubleAttributeMap;
    }
}

