/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.core.persistence;

import io.iworkflow.core.ObjectEncoder;
import io.iworkflow.core.WorkflowDefinitionException;
import io.iworkflow.core.persistence.StateExecutionLocals;
import io.iworkflow.gen.models.EncodedObject;
import io.iworkflow.gen.models.KeyValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StateExecutionLocalsImpl
implements StateExecutionLocals {
    private final Map<String, EncodedObject> recordEvents;
    private final Map<String, EncodedObject> attributeNameToEncodedObjectMap;
    private final Map<String, EncodedObject> upsertAttributesToReturnToServer;
    private final ObjectEncoder objectEncoder;

    public StateExecutionLocalsImpl(Map<String, EncodedObject> attributeNameToEncodedObjectMap, ObjectEncoder objectEncoder) {
        this.objectEncoder = objectEncoder;
        this.attributeNameToEncodedObjectMap = attributeNameToEncodedObjectMap;
        this.upsertAttributesToReturnToServer = new HashMap<String, EncodedObject>();
        this.recordEvents = new HashMap<String, EncodedObject>();
    }

    @Override
    public void setStateExecutionLocal(String key, Object value) {
        EncodedObject encodedData = this.objectEncoder.encode(value);
        this.attributeNameToEncodedObjectMap.put(key, encodedData);
        this.upsertAttributesToReturnToServer.put(key, encodedData);
    }

    @Override
    public <T> T getStateExecutionLocal(String key, Class<T> type) {
        EncodedObject encodedData = this.attributeNameToEncodedObjectMap.get(key);
        if (encodedData == null) {
            return null;
        }
        return this.objectEncoder.decode(encodedData, type);
    }

    @Override
    public void recordEvent(String key, Object ... eventData) {
        if (this.recordEvents.containsKey(key)) {
            throw new WorkflowDefinitionException("cannot record the same event for more than once");
        }
        if (eventData != null && eventData.length == 1) {
            this.recordEvents.put(key, this.objectEncoder.encode(eventData[0]));
        }
        this.recordEvents.put(key, this.objectEncoder.encode(eventData));
    }

    public List<KeyValue> getUpsertStateExecutionLocalAttributes() {
        return this.upsertAttributesToReturnToServer.entrySet().stream().map(stringEncodedObjectEntry -> new KeyValue().key((String)stringEncodedObjectEntry.getKey()).value((EncodedObject)stringEncodedObjectEntry.getValue())).collect(Collectors.toList());
    }

    public List<KeyValue> getRecordEvents() {
        return this.recordEvents.entrySet().stream().map(stringEncodedObjectEntry -> new KeyValue().key((String)stringEncodedObjectEntry.getKey()).value((EncodedObject)stringEncodedObjectEntry.getValue())).collect(Collectors.toList());
    }
}

