/*
 * Decompiled with CFR 0.152.
 */
package io.iworkflow.gen.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.Types;
import feign.jackson.JacksonDecoder;
import io.iworkflow.gen.models.ApiResponse;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ApiResponseDecoder
extends JacksonDecoder {
    public ApiResponseDecoder(ObjectMapper mapper) {
        super(mapper);
    }

    public Object decode(Response response, Type type) throws IOException {
        Map<String, List<String>> responseHeaders = Collections.unmodifiableMap(response.headers());
        if (type instanceof ParameterizedType && Types.getRawType((Type)type).isAssignableFrom(ApiResponse.class)) {
            Type responseBodyType = ((ParameterizedType)type).getActualTypeArguments()[0];
            Object body = super.decode(response, responseBodyType);
            return new ApiResponse<Object>(response.status(), responseHeaders, body);
        }
        return super.decode(response, type);
    }
}

