/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.openapi;

import io.javalin.Javalin;
import io.javalin.core.plugin.Plugin;
import io.javalin.core.plugin.PluginLifecycleInit;
import io.javalin.core.security.RouteRole;
import io.javalin.core.util.JavalinLogger;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import io.javalin.http.Handler;
import io.javalin.plugin.openapi.OpenApiHandler;
import io.javalin.plugin.openapi.OpenApiOptions;
import io.javalin.plugin.openapi.ui.OpenApiUiOptions;
import io.javalin.plugin.openapi.ui.ReDocRenderer;
import io.javalin.plugin.openapi.ui.SwaggerRenderer;
import io.javalin.plugin.openapi.utils.VersionIssuesUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lio/javalin/plugin/openapi/OpenApiPlugin;", "Lio/javalin/core/plugin/Plugin;", "Lio/javalin/core/plugin/PluginLifecycleInit;", "options", "", "Lio/javalin/plugin/openapi/OpenApiOptions;", "([Lio/javalin/plugin/openapi/OpenApiOptions;)V", "handlerMap", "", "", "Lio/javalin/plugin/openapi/OpenApiHandler;", "openApiHandler", "getOpenApiHandler", "()Lio/javalin/plugin/openapi/OpenApiHandler;", "setOpenApiHandler", "(Lio/javalin/plugin/openapi/OpenApiHandler;)V", "[Lio/javalin/plugin/openapi/OpenApiOptions;", "apply", "", "app", "Lio/javalin/Javalin;", "init", "javalin-openapi"})
public final class OpenApiPlugin
implements Plugin,
PluginLifecycleInit {
    @NotNull
    private final OpenApiOptions[] options;
    public OpenApiHandler openApiHandler;
    @NotNull
    private final Map<String, OpenApiHandler> handlerMap;

    public OpenApiPlugin(OpenApiOptions ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        if (VersionIssuesUtil.INSTANCE.getWarning() != null) {
            JavalinLogger.warn$default((String)Intrinsics.stringPlus((String)VersionIssuesUtil.INSTANCE.getWarning(), (Object)" - the OpenAPI plugin will not work properly. Please visit https://github.com/tipsy/javalin/issues/1193 if you want to help fix this issue."), null, (int)2, null);
        }
        boolean bl = false;
        this.handlerMap = new LinkedHashMap();
    }

    @NotNull
    public final OpenApiHandler getOpenApiHandler() {
        OpenApiHandler openApiHandler = this.openApiHandler;
        if (openApiHandler != null) {
            return openApiHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"openApiHandler");
        return null;
    }

    public final void setOpenApiHandler(@NotNull OpenApiHandler openApiHandler) {
        Intrinsics.checkNotNullParameter((Object)openApiHandler, (String)"<set-?>");
        this.openApiHandler = openApiHandler;
    }

    public void init(@NotNull Javalin app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        OpenApiOptions[] openApiOptionsArray = this.options;
        boolean bl = false;
        if (openApiOptionsArray.length == 0) {
            throw new IllegalArgumentException("The OpenApiPlugin requires at least one set of Options");
        }
        this.setOpenApiHandler(new OpenApiHandler(app, (OpenApiOptions)ArraysKt.first((Object[])this.options)));
        OpenApiOptions[] $this$forEach$iv = this.options;
        boolean $i$f$forEach = false;
        OpenApiOptions[] openApiOptionsArray2 = $this$forEach$iv;
        int n = openApiOptionsArray2.length;
        for (int i = 0; i < n; ++i) {
            OpenApiOptions element$iv;
            OpenApiOptions it = element$iv = openApiOptionsArray2[i];
            boolean bl2 = false;
            String string = it.getPath();
            if (string == null) continue;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String path = string2;
            boolean bl5 = false;
            this.handlerMap.putIfAbsent(path, new OpenApiHandler(app, it));
        }
    }

    public void apply(@NotNull Javalin app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Util.ensureDependencyPresent$default((Util)Util.INSTANCE, (OptionalDependency)OptionalDependency.SWAGGER_CORE, (boolean)false, (int)2, null);
        OpenApiOptions[] $this$forEach$iv = this.options;
        boolean $i$f$forEach = false;
        OpenApiOptions[] openApiOptionsArray = $this$forEach$iv;
        int n = openApiOptionsArray.length;
        for (int i = 0; i < n; ++i) {
            RouteRole[] routeRoleArray;
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            Collection $this$toTypedArray$iv;
            Object it;
            boolean bl;
            Object object;
            OpenApiOptions element$iv;
            OpenApiOptions options = element$iv = openApiOptionsArray[i];
            boolean bl2 = false;
            if (options.getPath() == null && (options.getSwagger() != null || options.getReDoc() != null)) {
                throw new IllegalStateException(StringsKt.replace$default((String)"Swagger or ReDoc is enabled, but there is no endpoint available for the OpenApi schema.\nPlease use the `path` option of the OpenApiPlugin to set a schema endpoint.", (String)"\n", (String)" ", (boolean)false, (int)4, null));
            }
            String string = options.getPath();
            if (string == null) continue;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String path = string2;
            boolean bl5 = false;
            OpenApiHandler openApiHandler = this.handlerMap.get(path);
            Intrinsics.checkNotNull((Object)openApiHandler);
            Collection $this$toTypedArray$iv2 = options.getRoles();
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            RouteRole[] routeRoleArray2 = thisCollection$iv2.toArray(new RouteRole[0]);
            if (routeRoleArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object object2 = routeRoleArray2;
            app.get(path, (Handler)openApiHandler, Arrays.copyOf(object2, ((RouteRole[])object2).length));
            object2 = options.getSwagger();
            if (object2 != null) {
                object = object2;
                bl = false;
                boolean bl6 = false;
                it = object;
                boolean bl7 = false;
                Util.assertWebjarInstalled((OptionalDependency)OptionalDependency.SWAGGERUI);
                $this$toTypedArray$iv = options.getRoles();
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new RouteRole[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                app.get(((OpenApiUiOptions)it).getPath(), (Handler)new SwaggerRenderer(options), Arrays.copyOf(routeRoleArray, routeRoleArray.length));
            }
            object2 = options.getReDoc();
            if (object2 != null) {
                object = object2;
                bl = false;
                boolean bl8 = false;
                it = object;
                boolean bl9 = false;
                Util.assertWebjarInstalled((OptionalDependency)OptionalDependency.REDOC);
                $this$toTypedArray$iv = options.getRoles();
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new RouteRole[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                app.get(((OpenApiUiOptions)it).getPath(), (Handler)new ReDocRenderer(options), Arrays.copyOf(routeRoleArray, routeRoleArray.length));
            }
            if (options.getSwagger() == null && options.getReDoc() == null) continue;
            app._conf.enableWebjars();
        }
    }
}

