/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.webhook.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.javaoperatorsdk.webhook.sample.commons.Utils;
import io.javaoperatorsdk.webhook.sample.commons.customresource.MultiVersionCustomResource;
import io.javaoperatorsdk.webhook.sample.commons.customresource.MultiVersionCustomResourceSpec;
import io.javaoperatorsdk.webhook.sample.commons.customresource.MultiVersionCustomResourceSpecV2;
import io.javaoperatorsdk.webhook.sample.commons.customresource.MultiVersionCustomResourceV2;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndToEndTestBase {
    protected KubernetesClient client = new KubernetesClientBuilder().build();
    public static final String TEST_CR_NAME = "test-cr";
    public static final int CR_SPEC_VALUE = 5;

    @Test
    void validationHook() {
        Ingress ingressWithLabel = Utils.testIngress((String)"normal-add-test");
        Utils.addRequiredLabels((Ingress)ingressWithLabel);
        Awaitility.await().atMost(Duration.ofSeconds(120L)).untilAsserted(() -> {
            Ingress res = this.avoidRequestTimeout(() -> (Ingress)((Resource)this.client.network().v1().ingresses().resource((Object)ingressWithLabel)).createOrReplace());
            AssertionsForInterfaceTypes.assertThat((Object)res).isNotNull();
        });
        Assertions.assertThrows(KubernetesClientException.class, () -> ((Resource)this.client.network().v1().ingresses().resource((Object)Utils.testIngress((String)"validate-test"))).createOrReplace());
    }

    @Test
    void mutationHook() {
        Ingress ingressWithLabel = Utils.testIngress((String)"mutation-test");
        Utils.addRequiredLabels((Ingress)ingressWithLabel);
        Awaitility.await().atMost(Duration.ofSeconds(120L)).untilAsserted(() -> {
            Ingress res = this.avoidRequestTimeout(() -> (Ingress)((Resource)this.client.network().v1().ingresses().resource((Object)ingressWithLabel)).createOrReplace());
            AssertionsForInterfaceTypes.assertThat((Object)res).isNotNull();
            AssertionsForInterfaceTypes.assertThat((Map)res.getMetadata().getLabels()).containsKey((Object)"app.kubernetes.io/id");
        });
    }

    @Test
    void conversionHook() {
        Awaitility.await().atMost(Duration.ofSeconds(120L)).untilAsserted(() -> this.avoidRequestTimeout(() -> this.createV1Resource(TEST_CR_NAME)));
        MultiVersionCustomResourceV2 v2 = (MultiVersionCustomResourceV2)((Resource)this.client.resources(MultiVersionCustomResourceV2.class).withName(TEST_CR_NAME)).get();
        AssertionsForInterfaceTypes.assertThat((String)((MultiVersionCustomResourceSpecV2)v2.getSpec()).getAlteredValue()).isEqualTo("5");
    }

    private MultiVersionCustomResource createV1Resource(String name) {
        MultiVersionCustomResource res = new MultiVersionCustomResource();
        res.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(name)).build());
        res.setSpec((Object)new MultiVersionCustomResourceSpec());
        ((MultiVersionCustomResourceSpec)res.getSpec()).setValue(5);
        return (MultiVersionCustomResource)this.client.resource((HasMetadata)res).createOrReplace();
    }

    <T> T avoidRequestTimeout(Supplier<T> operator) {
        try {
            return operator.get();
        }
        catch (KubernetesClientException e) {
            return null;
        }
    }

    public static void waitForCoreDNS(KubernetesClient client) {
        ((RollableScalableResource)((NonNamespaceOperation)client.apps().deployments().inNamespace("kube-system")).withName("coredns")).waitUntilReady(2L, TimeUnit.MINUTES);
    }
}

