/*
 * Decompiled with CFR 0.152.
 */
package io.jexxa.adapterapi.invocation;

import io.jexxa.adapterapi.invocation.JexxaInvocationHandler;
import io.jexxa.adapterapi.invocation.TransactionalInvocationHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class InvocationManager {
    private static final Map<Object, JexxaInvocationHandler> INVOCATION_HANDLER_MAP = new ConcurrentHashMap<Object, JexxaInvocationHandler>();
    private static JexxaInvocationHandler defaultInvocationHandler = new TransactionalInvocationHandler();

    public static void setInvocationHandler(JexxaInvocationHandler invocationHandler, Object object) {
        INVOCATION_HANDLER_MAP.put(object, invocationHandler);
    }

    public static void setDefaultInvocationHandler(JexxaInvocationHandler defaultInvocationHandler) {
        InvocationManager.defaultInvocationHandler = defaultInvocationHandler;
    }

    public static synchronized JexxaInvocationHandler getInvocationHandler(Object object) {
        return INVOCATION_HANDLER_MAP.computeIfAbsent(object, key -> InvocationManager.createDefaultInvocationHandler());
    }

    public static JexxaInvocationHandler getRootInterceptor(Object object) {
        return InvocationManager.getInvocationHandler(object);
    }

    private static JexxaInvocationHandler createDefaultInvocationHandler() {
        return defaultInvocationHandler.newInstance();
    }

    private InvocationManager() {
    }
}

