/*
 * Decompiled with CFR 0.152.
 */
package io.jexxa.adapterapi.invocation;

import io.jexxa.adapterapi.interceptor.AfterInterceptor;
import io.jexxa.adapterapi.interceptor.AroundInterceptor;
import io.jexxa.adapterapi.interceptor.BeforeInterceptor;
import io.jexxa.adapterapi.invocation.InvocationContext;
import io.jexxa.adapterapi.invocation.JexxaInvocationHandler;
import io.jexxa.adapterapi.invocation.context.ConsumerInvocationContext;
import io.jexxa.adapterapi.invocation.context.FunctionInvocationContext;
import io.jexxa.adapterapi.invocation.context.MethodInvocationContext;
import io.jexxa.adapterapi.invocation.context.RunnableInvocationContext;
import io.jexxa.adapterapi.invocation.context.SupplierInvocationContext;
import io.jexxa.adapterapi.invocation.function.SerializableConsumer;
import io.jexxa.adapterapi.invocation.function.SerializableFunction;
import io.jexxa.adapterapi.invocation.function.SerializableRunnable;
import io.jexxa.adapterapi.invocation.function.SerializableSupplier;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SharedInvocationHandler
implements AroundInterceptor,
BeforeInterceptor,
AfterInterceptor,
JexxaInvocationHandler {
    private final List<BeforeInterceptor> beforeList = new ArrayList<BeforeInterceptor>();
    private final List<AfterInterceptor> afterList = new ArrayList<AfterInterceptor>();
    private final List<AroundInterceptor> aroundList = new ArrayList<AroundInterceptor>();

    @Override
    public void before(InvocationContext invocationContext) {
        this.beforeList.forEach(element -> element.before(invocationContext));
    }

    @Override
    public void after(InvocationContext invocationContext) {
        this.afterList.forEach(element -> element.after(invocationContext));
    }

    @Override
    public void around(InvocationContext invocationContext) {
        invocationContext.proceed();
    }

    @Override
    public SharedInvocationHandler registerAround(AroundInterceptor interceptor) {
        this.aroundList.add(interceptor);
        return this;
    }

    @Override
    public SharedInvocationHandler registerBefore(BeforeInterceptor interceptor) {
        this.beforeList.add(interceptor);
        return this;
    }

    @Override
    public SharedInvocationHandler registerAfter(AfterInterceptor interceptor) {
        this.afterList.add(interceptor);
        return this;
    }

    @Override
    public Object invoke(Method method, Object object, Object[] args) {
        MethodInvocationContext invocationContext = new MethodInvocationContext(method, object, args, this.aroundList);
        this.invoke(invocationContext);
        return invocationContext.getReturnValue();
    }

    @Override
    public void invoke(Object targetObject, SerializableRunnable runnable) {
        RunnableInvocationContext invocationContext = new RunnableInvocationContext(targetObject, runnable, this.aroundList);
        this.invoke(invocationContext);
    }

    @Override
    public <T> void invoke(Object targetObject, SerializableConsumer<T> consumer, T argument) {
        ConsumerInvocationContext<T> invocationContext = new ConsumerInvocationContext<T>(targetObject, consumer, argument, this.aroundList);
        this.invoke(invocationContext);
    }

    @Override
    public <T> T invoke(Object targetObject, SerializableSupplier<T> supplier) {
        SupplierInvocationContext<T> invocationContext = new SupplierInvocationContext<T>(targetObject, supplier, this.aroundList);
        this.invoke(invocationContext);
        return invocationContext.getReturnValue();
    }

    @Override
    public JexxaInvocationHandler newInstance() {
        return new SharedInvocationHandler();
    }

    @Override
    public <T, R> R invoke(Object targetObject, SerializableFunction<T, R> function, T argument) {
        FunctionInvocationContext<T, R> invocationContext = new FunctionInvocationContext<T, R>(targetObject, function, argument, this.aroundList);
        this.invoke(invocationContext);
        return invocationContext.getReturnValue();
    }

    protected void invoke(InvocationContext invocationContext) {
        this.before(invocationContext);
        this.around(invocationContext);
        this.after(invocationContext);
    }
}

