/*
 * Decompiled with CFR 0.152.
 */
package io.jexxa.adapterapi.invocation.context;

import io.jexxa.adapterapi.interceptor.AroundInterceptor;
import io.jexxa.adapterapi.invocation.InvocationContext;
import io.jexxa.adapterapi.invocation.context.LambdaUtils;
import io.jexxa.adapterapi.invocation.function.SerializableFunction;
import java.lang.reflect.Method;
import java.util.Collection;

public class FunctionInvocationContext<T, R>
extends InvocationContext {
    private final SerializableFunction<T, R> function;
    private final T argument;
    private R returnValue;
    Method method;

    public FunctionInvocationContext(Object targetObject, SerializableFunction<T, R> function, T argument, Collection<AroundInterceptor> interceptors) {
        super(targetObject, interceptors);
        this.function = function;
        this.argument = argument;
    }

    @Override
    public void invoke() {
        this.returnValue = this.function.apply(this.argument);
    }

    @Override
    public Method getMethod() {
        if (this.method == null) {
            this.method = LambdaUtils.getImplMethod(this.getTarget(), this.function, this.getArgTypes());
        }
        return this.method;
    }

    @Override
    public Object[] getArgs() {
        return new Object[]{this.argument};
    }

    public R getReturnValue() {
        return this.returnValue;
    }
}

