/*
 * Decompiled with CFR 0.152.
 */
package io.jexxa.adapterapi.invocation.context;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class LambdaUtils {
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_MAP = new HashMap(16);

    public static String methodNameFromLambda(Serializable lambda) {
        try {
            Method lambdaMethod = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            lambdaMethod.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)lambdaMethod.invoke((Object)lambda, new Object[0]);
            return serializedLambda.getCapturingClass() + "/" + serializedLambda.getImplMethodName();
        }
        catch (ReflectiveOperationException ex) {
            return "unknownMethodName";
        }
    }

    static <T extends Serializable> Method getImplMethod(Object targetObject, T functionalInterface, Class<?>[] argTypes) {
        try {
            SerializedLambda serializedLambda = Objects.requireNonNull(LambdaUtils.getSerializedLambda(functionalInterface));
            return Arrays.stream(targetObject.getClass().getMethods()).filter(element -> element.getName().equals(serializedLambda.getImplMethodName())).filter(element -> LambdaUtils.isAssignable(element.getParameterTypes(), argTypes)).findAny().orElseThrow(() -> new NoSuchMethodException("Method not found " + targetObject.getClass() + "::" + serializedLambda.getImplMethodName()));
        }
        catch (NoSuchMethodException e) {
            if (LambdaUtils.includePrimitives(argTypes)) {
                return LambdaUtils.getImplMethod(targetObject, functionalInterface, LambdaUtils.convertToPrimitives(argTypes));
            }
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    static <T extends Serializable> SerializedLambda getSerializedLambda(T functionalInterface) {
        SerializedLambda serializedLambda = null;
        for (Class<?> clazz = functionalInterface.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method replaceMethod = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                replaceMethod.setAccessible(true);
                Object serialVersion = replaceMethod.invoke(functionalInterface, new Object[0]);
                if (serialVersion == null || serialVersion.getClass() != SerializedLambda.class) continue;
                serializedLambda = (SerializedLambda)serialVersion;
                break;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return serializedLambda;
    }

    private static Class<?>[] convertToPrimitives(Class<?>[] types) {
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = LambdaUtils.convertToPrimitive(types[i]);
        }
        return result;
    }

    private static Class<?> convertToPrimitive(Class<?> clazz) {
        if (WRAPPER_TYPE_MAP.containsKey(clazz)) {
            return WRAPPER_TYPE_MAP.get(clazz);
        }
        return clazz;
    }

    private static boolean includePrimitives(Class<?>[] types) {
        for (Class<?> type : types) {
            if (!WRAPPER_TYPE_MAP.containsKey(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignable(Class<?>[] original, Class<?>[] assignee) {
        if (original.length != assignee.length) {
            return false;
        }
        for (int i = 0; i < original.length; ++i) {
            if (original[i].isAssignableFrom(assignee[i])) continue;
            return false;
        }
        return true;
    }

    private LambdaUtils() {
    }

    static {
        WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
    }
}

