/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import io.jitstatic.client.APIException;
import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;

class APIHelper {
    APIHelper() {
    }

    static void addRefParameter(String ref, URIBuilder uriBuilder) {
        if (ref != null) {
            uriBuilder.addParameter("ref", ref);
        }
    }

    static void checkPUTStatusCode(URI uri, HttpPut putRequest, StatusLine statusLine, HttpEntity httpEntity) throws ParseException, IOException {
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 202: {
                break;
            }
            default: {
                throw new APIException(statusLine, uri.toString(), putRequest.getMethod(), httpEntity);
            }
        }
    }

    static String escapeVersion(String currentVersion) {
        if (currentVersion.isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be empty");
        }
        if (!currentVersion.startsWith("\"")) {
            currentVersion = "\"" + currentVersion;
        }
        if (!currentVersion.endsWith("\"")) {
            currentVersion = currentVersion + "\"";
        }
        return currentVersion;
    }

    static void checkGETresponse(URI url, HttpGet getRequest, StatusLine statusLine, HttpEntity httpEntity) throws ParseException, IOException {
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 202: 
            case 304: {
                break;
            }
            default: {
                throw new APIException(statusLine, url.toString(), getRequest.getMethod(), httpEntity);
            }
        }
    }

    static void checkDELETEresponse(URI url, HttpDelete request, StatusLine statusLine, HttpEntity httpEntity) throws ParseException, IOException {
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 202: {
                break;
            }
            default: {
                throw new APIException(statusLine, url.toString(), request.getMethod(), httpEntity);
            }
        }
    }

    static String getSingleHeader(CloseableHttpResponse httpResponse, String headerTag) {
        Header[] headers = httpResponse.getHeaders(headerTag);
        if (headers.length != 1) {
            return null;
        }
        return headers[0].getValue();
    }

    static String checkVersion(String version) {
        if (!version.startsWith("\"")) {
            version = "\"" + version;
        }
        if (!version.endsWith("\"")) {
            version = version + "\"";
        }
        return version;
    }

    public static void checkPOSTresponse(URI url, HttpPost postRequest, StatusLine statusLine, HttpEntity httpEntity) throws ParseException, IOException {
        switch (statusLine.getStatusCode()) {
            case 200: 
            case 202: {
                break;
            }
            default: {
                throw new APIException(statusLine, url.toString(), postRequest.getMethod(), httpEntity);
            }
        }
    }
}

