/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import io.jitstatic.client.BulkSearch;
import io.jitstatic.client.JsonEntity;
import io.jitstatic.client.SearchPath;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

class BulkSearchEntity
extends JsonEntity {
    private static final byte[] REF = BulkSearchEntity.getBytes("ref");
    private static final byte[] PATHS = BulkSearchEntity.getBytes("paths");
    private final List<BulkSearch> search;

    public BulkSearchEntity(List<BulkSearch> search) {
        this.search = search;
    }

    public void writeTo(OutputStream o) throws IOException {
        o.write(LEFTSQBRACKET);
        byte[] b = new byte[]{};
        for (BulkSearch bs : this.search) {
            o.write(b);
            o.write(LEFTBRACKET);
            this.writeField(REF, bs.getRef(), o);
            o.write(COMMA);
            o.write(DOUBLEQUOTE);
            o.write(PATHS);
            o.write(DOUBLEQUOTE);
            o.write(COLON);
            this.writeSearchPath(bs.getPaths(), o);
            o.write(RIGHTBRACKET);
            b = COMMA;
        }
        o.write(RIGHTSQBRACKET);
    }

    private void writeSearchPath(List<SearchPath> paths, OutputStream o) throws IOException {
        o.write(LEFTSQBRACKET);
        byte[] b = new byte[]{};
        for (SearchPath sp : paths) {
            o.write(b);
            o.write(LEFTBRACKET);
            new SearchPathEntity(sp).writeTo(o);
            o.write(RIGHTBRACKET);
            b = COMMA;
        }
        o.write(RIGHTSQBRACKET);
    }

    private static class SearchPathEntity
    extends JsonEntity {
        private static final byte[] PATH = SearchPathEntity.getBytes("path");
        private static final byte[] RECURSIVELY = SearchPathEntity.getBytes("recursively");
        private final SearchPath searchPath;

        public SearchPathEntity(SearchPath searchPath) {
            this.searchPath = searchPath;
        }

        public void writeTo(OutputStream o) throws IOException {
            this.writeField(PATH, this.searchPath.getPath(), o);
            o.write(COMMA);
            this.writeBool(RECURSIVELY, this.searchPath.isRecursivly(), o);
        }
    }
}

