/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import io.jitstatic.client.APIException;
import io.jitstatic.client.APIHelper;
import io.jitstatic.client.AddKeyEntity;
import io.jitstatic.client.BulkSearch;
import io.jitstatic.client.CommitData;
import io.jitstatic.client.JitStaticClient;
import io.jitstatic.client.MetaData;
import io.jitstatic.client.ModifyKeyEntity;
import io.jitstatic.client.ModifyUserKeyData;
import io.jitstatic.client.ModifyUserKeyEntity;
import io.jitstatic.client.ProjectVersion;
import io.jitstatic.client.TriFunction;
import io.jitstatic.client.UserData;
import io.jitstatic.client.UserDataEntity;
import io.jitstatic.client.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

class JitStaticClientImpl
implements JitStaticClient {
    private static final String ENTITY_FACTORY_CANNOT_BE_NULL = "entityFactory cannot be null";
    private static final String KEY_CANNOT_BE_NULL = "key cannot be null";
    protected static final String HTTPS = "https";
    protected static final String BULK = "bulk/";
    static final String HTTP = "http";
    protected static final String UTF_8 = "utf-8";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String JITSTATIC_METAKEY_ENDPOINT = "metakey/";
    protected static final String JITSTATIC_STORAGE_ENDPOINT = "storage/";
    protected static final String JITSTATIC_USERS_ENDPOINT = "users/";
    protected static final String JITSTATIC_KEYADMIN_ENDPOINT = "keyadmin/";
    protected static final String JITSTATIC_KEYUSER_ENDPOINT = "keyuser/";
    protected static final String JITSTATIC_GITUSER_ENDPOINT = "git/";
    protected static final Header[] HEADERS = new Header[]{new BasicHeader("Accept", "application/json"), new BasicHeader("Accept", "*/*;q=0.8"), new BasicHeader("Accept-Charset", "utf-8"), new BasicHeader("Accept-Encoding", "deflate, gzip;q=1.0, *;q=0.5"), new BasicHeader("User-Agent", String.format("jitstatic-client_%s-%s", ProjectVersion.INSTANCE.getBuildVersion(), ProjectVersion.INSTANCE.getCommitIdAbbrev()))};
    static final String REF = "ref";
    protected static final String RECURSIVE = "recursive";
    protected static final String LIGHT = "light";
    protected final CloseableHttpClient client;
    protected final URI storageURL;
    protected final URI metakeyURL;
    protected final URI baseURL;
    protected final URI bulkURL;
    protected final CredentialsProvider credentialsProvider;
    protected final HttpHost target;
    private final URI keyUserURL;
    private final URI keyAdminURL;
    private final URI keyGitUserURL;

    JitStaticClientImpl(String host, int port, String scheme, String appContext, String user, String password, CacheConfig cacheConfig, RequestConfig requestConfig, HttpClientBuilder httpClientBuilder, File cacheDir) throws URISyntaxException {
        Objects.requireNonNull(host, "host cannot be null");
        Objects.requireNonNull(appContext, "appContext cannot be null");
        Objects.requireNonNull(httpClientBuilder, "httpClientBuilder cannot be null");
        if (host.isEmpty()) {
            throw new IllegalArgumentException("host cannot be empty");
        }
        if (!appContext.startsWith("/")) {
            throw new IllegalArgumentException("appContext " + appContext + " doesn't start with an '/'");
        }
        if (!appContext.endsWith("/")) {
            throw new IllegalArgumentException("appContext " + appContext + " doesn't end with an '/'");
        }
        if (!Objects.requireNonNull(scheme).equalsIgnoreCase(HTTP) && !HTTPS.equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Not supported protocol " + scheme);
        }
        this.target = new HttpHost(host, port, scheme);
        if (requestConfig != null) {
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        if (cacheConfig != null) {
            if (!(httpClientBuilder instanceof CachingHttpClientBuilder)) {
                throw new IllegalArgumentException("A CacheConfig is specified but HttpClientBuilder is not an instance of CachingHttpClientBuilder");
            }
            CachingHttpClientBuilder chcb = (CachingHttpClientBuilder)httpClientBuilder;
            chcb.setCacheConfig(cacheConfig);
            if (cacheDir != null) {
                chcb.setCacheDir(cacheDir);
            }
        }
        if (user != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.target.getHostName(), this.target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            this.credentialsProvider = credsProvider;
        } else {
            this.credentialsProvider = null;
        }
        this.client = httpClientBuilder.build();
        this.baseURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(JITSTATIC_STORAGE_ENDPOINT);
        this.bulkURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(BULK);
        this.storageURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(JITSTATIC_STORAGE_ENDPOINT);
        this.metakeyURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(JITSTATIC_METAKEY_ENDPOINT);
        this.keyUserURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(JITSTATIC_USERS_ENDPOINT).resolve(JITSTATIC_KEYUSER_ENDPOINT);
        this.keyAdminURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(JITSTATIC_USERS_ENDPOINT).resolve(JITSTATIC_KEYADMIN_ENDPOINT);
        this.keyGitUserURL = new URIBuilder().setHost(host).setScheme(scheme).setPort(port).build().resolve(appContext).resolve(JITSTATIC_USERS_ENDPOINT).resolve(JITSTATIC_GITUSER_ENDPOINT);
    }

    @Deprecated
    JitStaticClientImpl(String host, int port, String scheme, String appContext, String user, String password, HttpClientBuilder httpClientBuilder, RequestConfig requestConfig) throws URISyntaxException {
        this(host, port, scheme, appContext, user, password, null, requestConfig, httpClientBuilder, null);
    }

    protected static HttpClientContext getHostContext(HttpHost target, CredentialsProvider credsProvider) {
        if (credsProvider != null) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(target, (AuthScheme)new BasicScheme());
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider(credsProvider);
            context.setAuthCache((AuthCache)authCache);
            return context;
        }
        return null;
    }

    private void checkPOStStatusCode(HttpPost postRequest, StatusLine statusLine, HttpEntity httpEntity) throws IOException {
        int statusCode = statusLine.getStatusCode();
        if (statusCode != 200) {
            throw new APIException(statusLine, this.storageURL.toString(), postRequest.getMethod(), httpEntity);
        }
    }

    @Override
    public <T> T getMetaKey(String key, String ref, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        return this.getMetaKey(key, ref, null, entityFactory);
    }

    @Override
    public <T> T getMetaKey(String key, String ref, String currentVersion, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        Objects.requireNonNull(key, KEY_CANNOT_BE_NULL);
        Objects.requireNonNull(entityFactory, ENTITY_FACTORY_CANNOT_BE_NULL);
        return this.getKey(key, ref, currentVersion, this.metakeyURL, entityFactory);
    }

    @Override
    public String modifyMetaKey(String key, String ref, String version, ModifyUserKeyData data) throws IOException, URISyntaxException {
        Objects.requireNonNull(data, "data cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
        ModifyUserKeyEntity entity = new ModifyUserKeyEntity(data);
        return this.modifyKey(key, ref, version, this.metakeyURL, entity);
    }

    protected URIBuilder resolve(String key, URI url) {
        if ("/".equals(key)) {
            return new URIBuilder(url);
        }
        return new URIBuilder(url.resolve(key));
    }

    @Override
    public String createKey(byte[] data, CommitData commitData, MetaData metaData) throws IOException, APIException, URISyntaxException {
        return this.createKey(new ByteArrayInputStream(data), commitData, metaData);
    }

    @Override
    public String createKey(InputStream data, CommitData commitData, MetaData metaData) throws IOException, APIException, URISyntaxException {
        Objects.requireNonNull(commitData);
        Objects.requireNonNull(metaData);
        AddKeyEntity entity = new AddKeyEntity(data, commitData, metaData);
        return this.addKey(commitData.getKey(), commitData.getBranch(), this.storageURL, entity);
    }

    @Override
    public String modifyKey(byte[] data, CommitData commitData, String version) throws URISyntaxException, IOException, APIException {
        return this.modifyKey(new ByteArrayInputStream(data), commitData, version);
    }

    @Override
    public String modifyKey(InputStream data, CommitData commitData, String version) throws URISyntaxException, IOException, APIException {
        Objects.requireNonNull(commitData, "commitData cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
        ModifyKeyEntity modify = new ModifyKeyEntity(data, commitData.getMessage(), commitData.getUserInfo(), commitData.getUserMail());
        return this.modifyKey(commitData.getKey(), commitData.getBranch(), version, this.storageURL, modify);
    }

    @Override
    public <T> T getKey(String key, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException, APIException {
        return this.getKey(key, null, entityFactory);
    }

    @Override
    public <T> T getKey(String key, TriFunction<InputStream, String, String, T> entityFactory, String currentVersion) throws URISyntaxException, IOException, APIException {
        return this.getKey(key, null, currentVersion, entityFactory);
    }

    @Override
    public <T> T getKey(String key, String ref, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException, APIException {
        return this.getKey(key, ref, null, entityFactory);
    }

    @Override
    public <T> T getKey(String key, String ref, String currentVersion, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException, APIException {
        return this.getKey(key, ref, currentVersion, this.storageURL, entityFactory);
    }

    @Override
    public <T> T listAll(String key, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        return this.listAll(key, null, entityFactory);
    }

    @Override
    public <T> T listAll(String key, String ref, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        return this.listAll(key, ref, false, entityFactory);
    }

    @Override
    public <T> T listAll(String key, boolean recursive, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        return this.listAll(key, null, recursive, entityFactory);
    }

    @Override
    public <T> T listAll(String key, boolean recursive, boolean light, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        return this.listAll(key, null, recursive, light, entityFactory);
    }

    @Override
    public <T> T listAll(String key, String ref, boolean recursive, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        return this.listAll(key, ref, recursive, false, entityFactory);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T listAll(String key, String ref, boolean recursive, boolean light, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T search(List<BulkSearch> search, Function<InputStream, T> entityFactory) throws URISyntaxException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void delete(CommitData commitData) throws URISyntaxException, IOException {
        Objects.requireNonNull(commitData);
        URIBuilder uriBuilder = this.resolve(commitData.getKey(), this.storageURL);
        APIHelper.addRefParameter(Utils.checkRef(commitData.getBranch()), uriBuilder);
        URI url = uriBuilder.build();
        HttpDelete deleteRequest = new HttpDelete(url);
        deleteRequest.setHeaders(HEADERS);
        deleteRequest.addHeader("X-jitstatic-name", commitData.getUserInfo());
        deleteRequest.addHeader("X-jitstatic-message", commitData.getMessage());
        deleteRequest.addHeader("X-jitstatic-mail", commitData.getUserMail());
        HttpClientContext context = JitStaticClientImpl.getHostContext(this.target, this.credentialsProvider);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)deleteRequest, (HttpContext)context);){
            StatusLine statusLine = httpResponse.getStatusLine();
            APIHelper.checkDELETEresponse(url, deleteRequest, statusLine, httpResponse.getEntity());
        }
    }

    @Override
    public String modifyUser(String user, String ref, UserData data, String currentVersion) throws URISyntaxException, IOException {
        return this.modifyKey(user, ref, currentVersion, this.keyUserURL, new UserDataEntity(data));
    }

    @Override
    public <T> T getUser(String user, String ref, String currentVersion, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        return this.getKey(user, ref, currentVersion, this.keyUserURL, entityFactory);
    }

    @Override
    public String addUser(String user, String ref, UserData data) throws URISyntaxException, IOException {
        return this.addKey(user, ref, this.keyUserURL, new UserDataEntity(data));
    }

    @Override
    public void deleteUser(String user, String ref) throws URISyntaxException, IOException {
        this.deleteUser(user, ref, this.keyUserURL);
    }

    @Override
    public <T> T getAdminUser(String user, String ref, String currentVersion, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        return this.getKey(user, ref, currentVersion, this.keyAdminURL, entityFactory);
    }

    @Override
    public String addAdminUser(String user, String ref, UserData data) throws URISyntaxException, IOException {
        return this.addKey(user, ref, this.keyAdminURL, new UserDataEntity(data));
    }

    @Override
    public String modifyAdminUser(String user, String ref, UserData data, String currentVersion) throws URISyntaxException, IOException {
        return this.modifyKey(user, ref, currentVersion, this.keyAdminURL, new UserDataEntity(data));
    }

    @Override
    public void deleteAdminUser(String user, String ref) throws URISyntaxException, IOException {
        this.deleteUser(user, ref, this.keyAdminURL);
    }

    @Override
    public <T> T getGitUser(String user, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        return this.getGitUser(user, null, entityFactory);
    }

    @Override
    public <T> T getGitUser(String user, String currentVersion, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        return this.getKey(user, null, currentVersion, this.keyGitUserURL, entityFactory);
    }

    @Override
    public String addGitUser(String user, UserData userData) throws URISyntaxException, IOException {
        return this.addKey(user, null, this.keyGitUserURL, new UserDataEntity(userData));
    }

    @Override
    public String modifyGitUser(String user, UserData userData, String currentVersion) throws URISyntaxException, IOException {
        return this.modifyKey(user, null, currentVersion, this.keyGitUserURL, new UserDataEntity(userData));
    }

    @Override
    public void deleteGitUser(String user) throws URISyntaxException, IOException {
        this.deleteUser(user, null, this.keyGitUserURL);
    }

    private String modifyKey(String key, String ref, String version, URI realm, HttpEntity entity) throws URISyntaxException, IOException {
        Objects.requireNonNull(key, KEY_CANNOT_BE_NULL);
        Objects.requireNonNull(entity, "entity cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
        URIBuilder uriBuilder = this.resolve(key, realm);
        APIHelper.addRefParameter(Utils.checkRef(ref), uriBuilder);
        URI uri = uriBuilder.build();
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeaders(HEADERS);
        putRequest.addHeader("If-Match", APIHelper.checkVersion(version));
        HttpClientContext context = JitStaticClientImpl.getHostContext(this.target, this.credentialsProvider);
        putRequest.setEntity(entity);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)putRequest, (HttpContext)context);){
            StatusLine statusLine = httpResponse.getStatusLine();
            APIHelper.checkPUTStatusCode(uri, putRequest, statusLine, httpResponse.getEntity());
            String string = APIHelper.getSingleHeader(httpResponse, "ETag");
            return string;
        }
    }

    private String addKey(String key, String ref, URI realm, HttpEntity entity) throws URISyntaxException, IOException {
        Objects.requireNonNull(key, KEY_CANNOT_BE_NULL);
        Objects.requireNonNull(entity, "entity cannot be null");
        URIBuilder uriBuilder = this.resolve(key, realm);
        APIHelper.addRefParameter(Utils.checkRef(ref), uriBuilder);
        URI url = uriBuilder.build();
        HttpPost postRequest = new HttpPost(url);
        postRequest.setHeaders(HEADERS);
        HttpClientContext context = JitStaticClientImpl.getHostContext(this.target, this.credentialsProvider);
        postRequest.setEntity(entity);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)postRequest, (HttpContext)context);){
            StatusLine statusLine = httpResponse.getStatusLine();
            this.checkPOStStatusCode(postRequest, statusLine, httpResponse.getEntity());
            String string = APIHelper.getSingleHeader(httpResponse, "ETag");
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T getKey(String key, String ref, String currentVersion, URI realm, TriFunction<InputStream, String, String, T> entityFactory) throws URISyntaxException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteUser(String user, String ref2, URI realm) throws URISyntaxException, IOException {
        URIBuilder uriBuilder = this.resolve(user, realm);
        APIHelper.addRefParameter(Utils.checkRef(ref2), uriBuilder);
        URI url = uriBuilder.build();
        HttpDelete deleteRequest = new HttpDelete(url);
        deleteRequest.setHeaders(HEADERS);
        HttpClientContext context = JitStaticClientImpl.getHostContext(this.target, this.credentialsProvider);
        try (CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)deleteRequest, (HttpContext)context);){
            StatusLine statusLine = httpResponse.getStatusLine();
            APIHelper.checkDELETEresponse(url, deleteRequest, statusLine, httpResponse.getEntity());
        }
    }
}

