/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

abstract class JsonEntity
implements HttpEntity {
    protected static final Charset UTF_8 = StandardCharsets.UTF_8;
    protected static final byte[] LEFTBRACKET = JsonEntity.getBytes("{");
    protected static final byte[] RIGHTBRACKET = JsonEntity.getBytes("}");
    protected static final byte[] COLON = JsonEntity.getBytes(":");
    protected static final byte[] DOUBLEQUOTE = JsonEntity.getBytes("\"");
    protected static final byte[] COMMA = JsonEntity.getBytes(",");
    protected static final byte[] LEFTSQBRACKET = JsonEntity.getBytes("[");
    protected static final byte[] RIGHTSQBRACKET = JsonEntity.getBytes("]");
    private static final byte[] TRUE = JsonEntity.getBytes("true");
    private static final byte[] FALSE = JsonEntity.getBytes("false");
    protected static final byte[] NIL = new byte[0];
    protected final AtomicBoolean bool = new AtomicBoolean(false);

    JsonEntity() {
    }

    protected void writeField(byte[] field, String value, OutputStream o) throws IOException {
        this.writeFieldToStream(field, JsonEntity.getBytes(value), o);
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "application/json");
    }

    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", UTF_8.name());
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getContent is unsupported");
    }

    public boolean isStreaming() {
        return this.bool.get();
    }

    @Deprecated
    public void consumeContent() throws IOException {
        throw new UnsupportedOperationException("consumeContent is unsupported");
    }

    private void writeFieldToStream(byte[] field, byte[] value, OutputStream o) throws IOException {
        o.write(DOUBLEQUOTE);
        o.write(field);
        o.write(DOUBLEQUOTE);
        o.write(COLON);
        o.write(DOUBLEQUOTE);
        o.write(value);
        o.write(DOUBLEQUOTE);
    }

    protected static byte[] getBytes(String tokens) {
        return tokens != null ? tokens.getBytes(UTF_8) : NIL;
    }

    protected void writeBool(byte[] field, boolean value, OutputStream o) throws IOException {
        o.write(DOUBLEQUOTE);
        o.write(field);
        o.write(DOUBLEQUOTE);
        o.write(COLON);
        o.write(value ? TRUE : FALSE);
    }
}

