/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import io.jitstatic.client.MetaData;
import io.jitstatic.client.MetaDataEntity;
import io.jitstatic.client.NoCloseWrappingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.commons.codec.binary.Base64OutputStream;

abstract class KeyEntity
extends MetaDataEntity {
    private final InputStream dataStream;
    private static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] DATA = KeyEntity.getBytes("data");
    protected static final Base64.Encoder ENCODER = Base64.getEncoder();

    public KeyEntity(MetaData data, InputStream dataStream) {
        super(data);
        this.dataStream = dataStream;
    }

    protected void writeDataField(OutputStream o) throws IOException {
        o.write(DOUBLEQUOTE);
        o.write(DATA);
        o.write(DOUBLEQUOTE);
        o.write(COLON);
        o.write(DOUBLEQUOTE);
        this.writeData(o);
        o.write(DOUBLEQUOTE);
    }

    protected void writeData(OutputStream o) throws IOException {
        int read = 0;
        byte[] buf = new byte[4096];
        try (Base64OutputStream b64 = new Base64OutputStream((OutputStream)new NoCloseWrappingOutputStream(o), true, -1, CHUNK_SEPARATOR);){
            while ((read = this.dataStream.read(buf)) != -1) {
                b64.write(buf, 0, read);
            }
        }
    }
}

