/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import io.jitstatic.client.HeaderPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MetaData {
    private final Set<User> users;
    private final String contentType;
    private final boolean hidden;
    private final boolean isProtected;
    private final List<HeaderPair> headers;
    private final Set<Role> read;
    private final Set<Role> write;

    public MetaData(String contenttype) {
        this(new HashSet<User>(), contenttype);
    }

    @Deprecated
    public MetaData(Set<User> users, String contentType, List<HeaderPair> headers) {
        this(users, contentType, false, false, headers);
    }

    public MetaData(Set<User> users, String contentType, boolean isProtected, boolean hidden, List<HeaderPair> headers, Set<Role> read, Set<Role> write) {
        this.users = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(users)));
        this.contentType = Objects.requireNonNull(contentType);
        this.isProtected = isProtected;
        this.hidden = hidden;
        this.headers = headers != null ? Collections.unmodifiableList(headers) : null;
        this.read = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(read)));
        this.write = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(write)));
    }

    @Deprecated
    public MetaData(Set<User> users, String contentType, boolean isProtected, boolean hidden, List<HeaderPair> headers) {
        this(users, contentType, isProtected, hidden, headers, new HashSet<Role>(), new HashSet<Role>());
    }

    @Deprecated
    public MetaData(Set<User> users, String contentType) {
        this(users, contentType, false, false, null);
    }

    @Deprecated
    public MetaData(Set<User> users, String type, List<HeaderPair> headers, Set<Role> read, Set<Role> write) {
        this(users, type, false, false, headers, read, write);
    }

    @Deprecated
    public MetaData(Set<User> users, String type, Set<Role> read, Set<Role> write) {
        this(users, type, new ArrayList<HeaderPair>(0), read, write);
    }

    public MetaData(String contentType, Set<Role> read, Set<Role> write) {
        this(new HashSet<User>(), contentType, read, write);
    }

    public MetaData(String type, List<HeaderPair> headers, Set<Role> read, Set<Role> write) {
        this(new HashSet<User>(), type, false, false, headers, read, write);
    }

    public MetaData(String type, boolean isProtected, boolean hidden, Set<Role> read, Set<Role> write) {
        this(new HashSet<User>(), type, isProtected, hidden, new ArrayList<HeaderPair>(0), read, write);
    }

    @Deprecated
    public final Set<User> getUsers() {
        return this.users;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public List<HeaderPair> getHeaders() {
        return this.headers;
    }

    public Set<Role> getRead() {
        return this.read;
    }

    public Set<Role> getWrite() {
        return this.write;
    }

    public static class Role {
        private final String role;

        public Role(String role) {
            this.role = Objects.requireNonNull(role);
        }

        public String getRole() {
            return this.role;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Role other = (Role)obj;
            return !(this.role == null ? other.role != null : !this.role.equals(other.role));
        }
    }

    public static final class User {
        private final String user;
        private final String password;

        public User(String user, String password) {
            this.user = Objects.requireNonNull(user);
            this.password = Objects.requireNonNull(password);
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            User other = (User)obj;
            return !(this.user == null ? other.user != null : !this.user.equals(other.user));
        }
    }
}

