/*
 * Decompiled with CFR 0.152.
 */
package io.jitstatic.client;

import io.jitstatic.client.HeaderPair;
import io.jitstatic.client.JsonEntity;
import io.jitstatic.client.MetaData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;

abstract class MetaDataEntity
extends JsonEntity {
    private static final byte[] METADATA = MetaDataEntity.getBytes("metaData");
    private static final byte[] USERS = MetaDataEntity.getBytes("users");
    private static final byte[] PASSWORD = MetaDataEntity.getBytes("password");
    private static final byte[] CONTENTTYPE = MetaDataEntity.getBytes("contentType");
    private static final byte[] PROTECTED = MetaDataEntity.getBytes("protected");
    private static final byte[] HIDDEN = MetaDataEntity.getBytes("hidden");
    private static final byte[] HEADERS = MetaDataEntity.getBytes("headers");
    private static final byte[] HEADER = MetaDataEntity.getBytes("header");
    private static final byte[] VALUE = MetaDataEntity.getBytes("value");
    protected static final byte[] USER = MetaDataEntity.getBytes("user");
    protected static final byte[] USERINFO = MetaDataEntity.getBytes("userInfo");
    protected static final byte[] USERMAIL = MetaDataEntity.getBytes("userMail");
    protected static final byte[] MESSAGE = MetaDataEntity.getBytes("message");
    protected static final byte[] READ = MetaDataEntity.getBytes("read");
    protected static final byte[] WRITE = MetaDataEntity.getBytes("write");
    protected static final byte[] ROLE = MetaDataEntity.getBytes("role");
    private final MetaData data;

    public MetaDataEntity(MetaData data) {
        this.data = data;
    }

    protected void writeMetaDataField(OutputStream o) throws IOException {
        o.write(DOUBLEQUOTE);
        o.write(METADATA);
        o.write(DOUBLEQUOTE);
        o.write(COLON);
        o.write(LEFTBRACKET);
        if (this.data != null) {
            o.write(DOUBLEQUOTE);
            o.write(USERS);
            o.write(DOUBLEQUOTE);
            o.write(COLON);
            this.writeUsers(o);
            o.write(COMMA);
            this.writeField(CONTENTTYPE, this.data.getContentType(), o);
            o.write(COMMA);
            this.writeBool(PROTECTED, this.data.isProtected(), o);
            o.write(COMMA);
            this.writeBool(HIDDEN, this.data.isHidden(), o);
            if (this.data.getHeaders() != null) {
                o.write(COMMA);
                this.writeHeaders(this.data.getHeaders(), o);
            }
            o.write(COMMA);
            this.writeRoles(READ, this.data.getRead(), o);
            o.write(COMMA);
            this.writeRoles(WRITE, this.data.getWrite(), o);
        }
        o.write(RIGHTBRACKET);
    }

    private void writeRoles(byte[] type, Set<MetaData.Role> roles2, OutputStream o) throws IOException {
        o.write(DOUBLEQUOTE);
        o.write(type);
        o.write(DOUBLEQUOTE);
        o.write(COLON);
        o.write(LEFTSQBRACKET);
        byte[] b = NIL;
        for (MetaData.Role r : roles2) {
            o.write(b);
            o.write(LEFTBRACKET);
            this.writeField(ROLE, r.getRole(), o);
            o.write(RIGHTBRACKET);
            b = COMMA;
        }
        o.write(RIGHTSQBRACKET);
    }

    private void writeHeaders(List<HeaderPair> headers, OutputStream o) throws IOException {
        o.write(DOUBLEQUOTE);
        o.write(HEADERS);
        o.write(DOUBLEQUOTE);
        o.write(COLON);
        o.write(LEFTSQBRACKET);
        byte[] b = NIL;
        for (HeaderPair hp : headers) {
            o.write(b);
            o.write(LEFTBRACKET);
            this.writeField(HEADER, hp.getHeader(), o);
            o.write(COMMA);
            this.writeField(VALUE, hp.getValue(), o);
            o.write(RIGHTBRACKET);
            b = COMMA;
        }
        o.write(RIGHTSQBRACKET);
    }

    private void writeUsers(OutputStream o) throws IOException {
        Set<MetaData.User> users = this.data.getUsers();
        byte[] b = NIL;
        o.write(LEFTSQBRACKET);
        for (MetaData.User user : users) {
            o.write(b);
            o.write(LEFTBRACKET);
            this.writeField(USER, user.getUser(), o);
            o.write(COMMA);
            this.writeField(PASSWORD, user.getPassword(), o);
            o.write(RIGHTBRACKET);
            b = COMMA;
        }
        o.write(RIGHTSQBRACKET);
    }
}

