/*
 * Decompiled with CFR 0.152.
 */
package io.jobial.scase.core.javadsl;

import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import io.jobial.scase.core.javadsl.ReceiverClient;
import io.jobial.scase.core.javadsl.RequestResponseClient;
import io.jobial.scase.core.javadsl.SenderClient;
import io.jobial.scase.core.javadsl.Service;
import io.jobial.scase.core.javadsl.package$;
import io.jobial.scase.util.Hash$;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;

public class JavaUtils {
    public static ExecutionContext executionContext = io.jobial.scase.core.impl.package$.MODULE$.blockerContext();
    public static ContextShift<IO> contextShift = IO.contextShift((ExecutionContext)executionContext);
    public static Concurrent<IO> concurrent = IO$.MODULE$.ioConcurrentEffect(contextShift);
    public static Timer<IO> timer = IO$.MODULE$.timer(executionContext);

    public static <T> CompletableFuture<T> scalaFutureToCompletableFuture(Future<T> future) {
        return package$.MODULE$.scalaFutureToCompletableFuture(future, executionContext);
    }

    public static <T> CompletableFuture<T> ioToCompletableFuture(IO<T> iO) {
        return JavaUtils.scalaFutureToCompletableFuture(iO.unsafeToFuture());
    }

    public static <T> IO<T> completableFutureToIO(CompletableFuture<T> completableFuture) {
        return package$.MODULE$.completableFutureToIO(completableFuture, contextShift);
    }

    private static <T> Future<T> completableFutureToScalaFuture(CompletableFuture<T> completableFuture) {
        return package$.MODULE$.completableFutureToScalaFuture(completableFuture);
    }

    public static <T> Option<T> javaOptionalToScala(Optional<T> optional) {
        if (optional.isPresent()) {
            return Some$.MODULE$.apply(optional.get());
        }
        return Option$.MODULE$.empty();
    }

    public static <T> Optional<T> scalaOptionToJava(Option<T> option) {
        if (option.isDefined()) {
            return Optional.of(option.get());
        }
        return Optional.empty();
    }

    public static FiniteDuration javaDurationToScala(java.time.Duration duration) {
        return Duration.fromNanos((long)duration.toNanos());
    }

    public static java.time.Duration scalaDurationToJava(Duration duration) {
        return java.time.Duration.of(duration.toNanos(), ChronoUnit.NANOS);
    }

    public static Option<FiniteDuration> javaOptionalDurationToScala(Optional<java.time.Duration> optional) {
        return JavaUtils.javaOptionalToScala(optional.map(duration -> JavaUtils.javaDurationToScala(duration)));
    }

    public static Optional<java.time.Duration> scalaOptionDurationToJava(Option<FiniteDuration> option) {
        return JavaUtils.scalaOptionToJava(option).map(finiteDuration -> JavaUtils.scalaDurationToJava((Duration)finiteDuration));
    }

    public static <A, B> Map<A, B> javaMapToScala(java.util.Map<A, B> map) {
        return package$.MODULE$.javaMapToScala(map);
    }

    public static <A, B> Function1<A, B> javaFunctionToScala(Function<A, B> function) {
        return package$.MODULE$.javaFunctionToScala(function);
    }

    public static Function0<BoxedUnit> javaRunnableToScala(Runnable runnable) {
        return package$.MODULE$.javaRunnableToScala(runnable);
    }

    public static String uuid(int n) {
        return Hash$.MODULE$.uuid(n, 36);
    }

    public static CompletableFuture<Service> service(Object object) {
        return JavaUtils.ioToCompletableFuture((IO)object).thenApply(service -> new Service((io.jobial.scase.core.Service<IO>)service));
    }

    public static <M> CompletableFuture<ReceiverClient<M>> receiverClient(Object object) {
        return JavaUtils.ioToCompletableFuture((IO)object).thenApply(receiverClient -> new ReceiverClient(receiverClient));
    }

    public static <REQ, RESP> CompletableFuture<RequestResponseClient<REQ, RESP>> requestResponseClient(Object object) {
        return JavaUtils.ioToCompletableFuture((IO)object).thenApply(requestResponseClient -> new RequestResponseClient(requestResponseClient));
    }

    public static <REQ> CompletableFuture<SenderClient<REQ>> senderClient(Object object) {
        return JavaUtils.ioToCompletableFuture((IO)object).thenApply(senderClient -> new SenderClient(senderClient));
    }
}

