/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.utils;

import io.joern.c2cpg.Config;
import io.joern.c2cpg.utils.ExternalCommand$;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;

public final class IncludeAutoDiscovery$ {
    public static final IncludeAutoDiscovery$ MODULE$ = new IncludeAutoDiscovery$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final boolean IS_WIN;
    private static final String GCC_VERSION_COMMAND;
    private static final String CPP_INCLUDE_COMMAND;
    private static final String C_INCLUDE_COMMAND;
    private static Option<Object> isGccAvailable;
    private static Set<Path> systemIncludePathsC;
    private static Set<Path> systemIncludePathsCPP;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        IS_WIN = Properties$.MODULE$.isWin();
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        GCC_VERSION_COMMAND = "gcc --version";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        CPP_INCLUDE_COMMAND = MODULE$.IS_WIN() ? "gcc -xc++ -E -v . -o nul" : "gcc -xc++ -E -v /dev/null -o /dev/null";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        C_INCLUDE_COMMAND = MODULE$.IS_WIN() ? "gcc -xc -E -v . -o nul" : "gcc -xc -E -v /dev/null -o /dev/null";
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        isGccAvailable = None$.MODULE$;
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
        systemIncludePathsC = Predef$.MODULE$.Set().empty();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x40);
        systemIncludePathsCPP = Predef$.MODULE$.Set().empty();
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x80);
    }

    private Logger logger() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 12");
        }
        return logger;
    }

    private boolean IS_WIN() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 14");
        }
        return IS_WIN;
    }

    public String GCC_VERSION_COMMAND() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 16");
        }
        return GCC_VERSION_COMMAND;
    }

    private String CPP_INCLUDE_COMMAND() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 18");
        }
        return CPP_INCLUDE_COMMAND;
    }

    private String C_INCLUDE_COMMAND() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 21");
        }
        return C_INCLUDE_COMMAND;
    }

    private Option<Object> isGccAvailable() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 25");
        }
        return isGccAvailable;
    }

    private void isGccAvailable_$eq(Option<Object> x$1) {
        isGccAvailable = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    private Set<Path> systemIncludePathsC() {
        if ((byte)(bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 28");
        }
        return systemIncludePathsC;
    }

    private void systemIncludePathsC_$eq(Set<Path> x$1) {
        systemIncludePathsC = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x40);
    }

    private Set<Path> systemIncludePathsCPP() {
        if ((byte)(bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/c2cpg/src/main/scala/io/joern/c2cpg/utils/IncludeAutoDiscovery.scala: 29");
        }
        return systemIncludePathsCPP;
    }

    private void systemIncludePathsCPP_$eq(Set<Path> x$1) {
        systemIncludePathsCPP = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x80);
    }

    private boolean checkForGcc() {
        boolean bl;
        this.logger().debug("Checking gcc ...");
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(this.GCC_VERSION_COMMAND());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq result = (Seq)success.value();
            this.logger().debug(new StringBuilder(18).append("GCC is available: ").append(result.mkString(System.lineSeparator())).toString());
            bl = true;
        } else {
            this.logger().warn("GCC is not installed. Discovery of system include paths will not be available.");
            bl = false;
        }
        return bl;
    }

    public boolean gccAvailable() {
        boolean bl;
        Option<Object> option = this.isGccAvailable();
        if (option instanceof Some) {
            boolean value;
            Some some = (Some)option;
            bl = value = BoxesRunTime.unboxToBoolean((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.isGccAvailable_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.checkForGcc())));
            bl = BoxesRunTime.unboxToBoolean((Object)this.isGccAvailable().get());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private Set<Path> extractPaths(Seq<String> output) {
        int startIndex = output.indexWhere((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("#include"))) + 2;
        int endIndex = this.IS_WIN() ? output.indexWhere((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("End of search list."))) - 1 : output.indexWhere((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith("COMPILER_PATH"))) - 1;
        return ((IterableOnceOps)((IterableOps)output.slice(startIndex, endIndex)).map((Function1 & Serializable)p -> Paths.get(p.trim(), new String[0]).toRealPath(new LinkOption[0]))).toSet();
    }

    private Set<Path> discoverPaths(String command) {
        Set set;
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(command);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq output = (Seq)success.value();
            set = this.extractPaths((Seq<String>)output);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().warn(new StringBuilder(59).append("Unable to discover system include paths. Running '").append(command).append("' failed.").toString(), exception);
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(try_);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Path> discoverIncludePathsC(Config config) {
        Set set;
        if (config.includePathsAutoDiscovery() && this.systemIncludePathsC().nonEmpty()) {
            set = this.systemIncludePathsC();
        } else if (config.includePathsAutoDiscovery() && this.systemIncludePathsC().isEmpty() && this.gccAvailable()) {
            void var2_2;
            Set<Path> includePathsC = this.discoverPaths(this.C_INCLUDE_COMMAND());
            if (includePathsC.nonEmpty()) {
                this.logger().info(new StringBuilder(43).append("Using the following C system include paths:").append(includePathsC.mkString(new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), System.lineSeparator())).toString());
            }
            this.systemIncludePathsC_$eq(includePathsC);
            set = var2_2;
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Path> discoverIncludePathsCPP(Config config) {
        Set set;
        if (config.includePathsAutoDiscovery() && this.systemIncludePathsCPP().nonEmpty()) {
            set = this.systemIncludePathsCPP();
        } else if (config.includePathsAutoDiscovery() && this.systemIncludePathsCPP().isEmpty() && this.gccAvailable()) {
            void var2_2;
            Set<Path> includePathsCPP = this.discoverPaths(this.CPP_INCLUDE_COMMAND());
            if (includePathsCPP.nonEmpty()) {
                this.logger().info(new StringBuilder(45).append("Using the following CPP system include paths:").append(includePathsCPP.mkString(new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), System.lineSeparator())).toString());
            }
            this.systemIncludePathsCPP_$eq(includePathsCPP);
            set = var2_2;
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    private IncludeAutoDiscovery$() {
    }
}

