/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.passes;

import better.files.File$;
import io.joern.c2cpg.Config;
import io.joern.c2cpg.datastructures.CGlobal$;
import io.joern.c2cpg.utils.IncludeAutoDiscovery$;
import io.joern.x2cpg.Ast;
import io.joern.x2cpg.Ast$;
import io.joern.x2cpg.passes.frontend.MetaDataPass$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Comment;
import io.shiftleft.codepropertygraph.generated.nodes.Local;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.NamespaceBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewFile;
import io.shiftleft.codepropertygraph.generated.nodes.NewFile$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn$;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewNode;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl$;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.codepropertygraph.generated.nodes.Type;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.codepropertygraph.generated.traversal.TypeDeclTraversalExtGen$;
import io.shiftleft.passes.SimpleCpgPass;
import io.shiftleft.passes.SimpleCpgPass$;
import io.shiftleft.semanticcpg.language.types.structure.NamespaceTraversal$;
import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.Node;
import overflowdb.NodeOrDetachedNode;
import overflowdb.traversal.NodeTraversal$;
import overflowdb.traversal.Traversal;
import overflowdb.traversal.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class HeaderContentPass
extends SimpleCpgPass {
    private final Cpg cpg;
    private final Set<Path> systemIncludePaths;
    private final String filename;
    private final String globalName;
    private final String fullName;
    private final Set<String> typeDeclFullNames;

    public HeaderContentPass(Cpg cpg, Config config) {
        this.cpg = cpg;
        super(cpg, SimpleCpgPass$.MODULE$.$lessinit$greater$default$2(), SimpleCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.systemIncludePaths = (Set)IncludeAutoDiscovery$.MODULE$.discoverIncludePathsC(config).$plus$plus(IncludeAutoDiscovery$.MODULE$.discoverIncludePathsCPP(config));
        String absolutePath = File$.MODULE$.apply(config.inputPath(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath().normalize().toString();
        this.filename = new StringBuilder(11).append(absolutePath).append(":<includes>").toString();
        this.globalName = NamespaceTraversal$.MODULE$.globalNamespaceName();
        this.fullName = MetaDataPass$.MODULE$.getGlobalNamespaceBlockFullName((Option)Some$.MODULE$.apply((Object)this.filename));
        IterableOnce iterableOnce = io.shiftleft.semanticcpg.language.package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg).typeDecl());
        this.typeDeclFullNames = TypeDeclTraversalExtGen$.MODULE$.fullName$extension(iterableOnce).toSetImmutable();
    }

    private NewBlock createGlobalBlock(BatchedUpdate.DiffGraphBuilder dstGraph) {
        NewFile includesFile = NewFile$.MODULE$.apply().name(this.filename);
        NewNamespaceBlock namespaceBlock = NewNamespaceBlock$.MODULE$.apply().name(this.globalName).fullName(this.fullName).filename(this.filename);
        NewMethod fakeGlobalIncludesMethod = NewMethod$.MODULE$.apply().name(this.globalName).code(this.globalName).fullName(this.fullName).filename(this.filename).lineNumber(Predef$.MODULE$.int2Integer(1)).astParentType("NAMESPACE_BLOCK").astParentFullName(this.fullName);
        NewBlock blockNode = NewBlock$.MODULE$.apply().typeFullName("ANY");
        NewMethodReturn methodReturn = NewMethodReturn$.MODULE$.apply().code("RET").evaluationStrategy("BY_VALUE").typeFullName("ANY");
        Ast ast = Ast$.MODULE$.apply((NewNode)includesFile).withChild(Ast$.MODULE$.apply((NewNode)namespaceBlock).withChild(Ast$.MODULE$.apply((NewNode)fakeGlobalIncludesMethod).withChild(Ast$.MODULE$.apply((NewNode)blockNode)).withChild(Ast$.MODULE$.apply((NewNode)methodReturn))));
        Ast$.MODULE$.storeInDiffGraph(ast, dstGraph);
        return blockNode;
    }

    private void createMissingAstEdges(BatchedUpdate.DiffGraphBuilder dstGraph) {
        NewBlock globalBlock = this.createGlobalBlock(dstGraph);
        io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg).all().not((Function1 & Serializable)_$1 -> {
            Traversal traversal = package$.MODULE$.toNodeTraversal(_$1);
            return NodeTraversal$.MODULE$.inE$extension(traversal, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AST"}));
        }).foreach((Function1 & Serializable)x$1 -> {
            BatchedUpdate.DiffGraphBuilder diffGraphBuilder;
            StoredNode storedNode = x$1;
            if (storedNode instanceof Comment) {
                Comment srcNode = (Comment)storedNode;
                diffGraphBuilder = dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)srcNode, "AST");
            } else if (storedNode instanceof NamespaceBlock) {
                NamespaceBlock srcNode = (NamespaceBlock)storedNode;
                diffGraphBuilder = dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)srcNode, "AST");
            } else if (storedNode instanceof Method) {
                Method srcNode = (Method)storedNode;
                dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)srcNode, "AST");
                if (this.systemIncludePaths.exists((Function1 & Serializable)p -> srcNode.filename().startsWith(p.toString()))) {
                    dstGraph.setNodeProperty((Node)srcNode, "IS_EXTERNAL", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    diffGraphBuilder = BoxedUnit.UNIT;
                } else {
                    diffGraphBuilder = BoxedUnit.UNIT;
                }
            } else if (storedNode instanceof TypeDecl) {
                TypeDecl srcNode = (TypeDecl)storedNode;
                dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)srcNode, "AST");
                if (this.systemIncludePaths.exists((Function1 & Serializable)p -> srcNode.filename().startsWith(p.toString()))) {
                    dstGraph.setNodeProperty((Node)srcNode, "IS_EXTERNAL", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    diffGraphBuilder = BoxedUnit.UNIT;
                } else {
                    diffGraphBuilder = BoxedUnit.UNIT;
                }
            } else if (storedNode instanceof Local) {
                Local srcNode = (Local)storedNode;
                diffGraphBuilder = dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)srcNode, "AST");
            } else {
                diffGraphBuilder = BoxedUnit.UNIT;
            }
            return diffGraphBuilder;
        });
    }

    private boolean typeNeedsTypeDeclStub(Type t) {
        return !this.typeDeclFullNames.contains((Object)t.typeDeclFullName());
    }

    private void createMissingTypeDecls(BatchedUpdate.DiffGraphBuilder dstGraph) {
        ((IterableOnceOps)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg).typ().filter((Function1 & Serializable)t -> this.typeNeedsTypeDeclStub((Type)t))).foreach((Function1 & Serializable)t -> {
            NewTypeDecl newTypeDecl = NewTypeDecl$.MODULE$.apply().name(t.name()).fullName(t.typeDeclFullName()).code(t.name()).isExternal(true).filename(this.filename).astParentType("NAMESPACE_BLOCK").astParentFullName(this.fullName);
            return dstGraph.addNode((DetachedNodeData)newTypeDecl);
        });
    }

    public void run(BatchedUpdate.DiffGraphBuilder dstGraph) {
        if (CGlobal$.MODULE$.shouldBeCleared()) {
            this.createMissingAstEdges(dstGraph);
            this.createMissingTypeDecls(dstGraph);
        }
    }
}

