/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.parser;

import io.joern.c2cpg.parser.HeaderFileFinder;
import java.io.Serializable;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Some$;

public class CustomFileContentProvider
extends InternalFileContentProvider {
    private final HeaderFileFinder headerFileFinder;
    private final Logger logger;

    public CustomFileContentProvider(HeaderFileFinder headerFileFinder) {
        this.headerFileFinder = headerFileFinder;
        this.logger = LoggerFactory.getLogger(CustomFileContentProvider.class);
    }

    private InternalFileContent loadContent(String path) {
        Option<String> maybeFileName = !this.getInclusionExists(path) ? this.headerFileFinder.find(path) : Some$.MODULE$.apply((Object)path);
        return (InternalFileContent)maybeFileName.map((Function1 & Serializable)fileName -> {
            this.logger.debug(new StringBuilder(22).append("Loading header file '").append((String)fileName).append("'").toString());
            FileContent content = FileContent.createForExternalFileLocation((String)fileName);
            return (InternalFileContent)content;
        }).getOrElse(() -> this.loadContent$$anonfun$2(path));
    }

    public InternalFileContent getContentForInclusion(String path, IMacroDictionary macroDictionary) {
        return this.loadContent(path);
    }

    public InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
        return this.loadContent(astPath);
    }

    private final InternalFileContent loadContent$$anonfun$2(String path$1) {
        this.logger.debug(new StringBuilder(30).append("Cannot find header file for '").append(path$1).append("'").toString());
        return null;
    }
}

