/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.parser;

import better.files.File;
import better.files.File$;
import io.joern.c2cpg.C2Cpg;
import io.joern.c2cpg.parser.CdtParser$;
import io.joern.c2cpg.parser.CdtParser$ParseResult$;
import io.joern.c2cpg.parser.CustomFileContentProvider;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.parser.HeaderFileFinder;
import io.joern.c2cpg.parser.ParseProblemsLogger;
import io.joern.c2cpg.parser.ParserConfig;
import io.joern.c2cpg.parser.ParserConfig$;
import io.joern.c2cpg.parser.PreprocessorStatementsLogger;
import io.joern.c2cpg.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class CdtParser
implements ParseProblemsLogger,
PreprocessorStatementsLogger {
    private Logger io$joern$c2cpg$parser$ParseProblemsLogger$$logger;
    private Logger io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger;
    private final HeaderFileFinder headerFileFinder;
    private final ParserConfig parserConfig;
    private final Map<String, String> definedSymbols;
    private final Set<Path> includePaths;
    private final DefaultLogService log;
    private final int opts;

    public CdtParser(C2Cpg.Config config) {
        ParseProblemsLogger.$init$(this);
        PreprocessorStatementsLogger.$init$(this);
        this.headerFileFinder = new HeaderFileFinder(config.inputPaths());
        this.parserConfig = ParserConfig$.MODULE$.fromConfig(config);
        this.definedSymbols = CollectionConverters$.MODULE$.MapHasAsJava(this.parserConfig.definedSymbols()).asJava();
        this.includePaths = this.parserConfig.userIncludePaths();
        this.log = new DefaultLogService();
        this.opts = 32;
        Statics.releaseFence();
    }

    @Override
    public Logger io$joern$c2cpg$parser$ParseProblemsLogger$$logger() {
        return this.io$joern$c2cpg$parser$ParseProblemsLogger$$logger;
    }

    @Override
    public void io$joern$c2cpg$parser$ParseProblemsLogger$_setter_$io$joern$c2cpg$parser$ParseProblemsLogger$$logger_$eq(Logger x$0) {
        this.io$joern$c2cpg$parser$ParseProblemsLogger$$logger = x$0;
    }

    @Override
    public Logger io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger() {
        return this.io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger;
    }

    @Override
    public void io$joern$c2cpg$parser$PreprocessorStatementsLogger$_setter_$io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger_$eq(Logger x$0) {
        this.io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger = x$0;
    }

    private ILanguage createParseLanguage(Path file) {
        return FileDefaults$.MODULE$.isCPPFile(file.toString()) ? GPPLanguage.getDefault() : GCCLanguage.getDefault();
    }

    private ScannerInfo createScannerInfo(Path file) {
        Set<Path> additionalIncludes = FileDefaults$.MODULE$.isCPPFile(file.toString()) ? this.parserConfig.systemIncludePathsCPP() : this.parserConfig.systemIncludePathsC();
        return new ScannerInfo(this.definedSymbols, (String[])((IterableOnceOps)this.includePaths.$plus$plus(additionalIncludes).map((Function1 & Serializable)_$1 -> _$1.toString())).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParseResult parseInternal(Path file) {
        ParseResult parseResult;
        File realPath = File$.MODULE$.apply(file);
        if (realPath.isRegularFile(realPath.isRegularFile$default$1())) {
            ScannerInfo scannerInfo;
            ILanguage lang;
            CustomFileContentProvider fileContentProvider;
            FileContent fileContent = IOUtils$.MODULE$.readFileAsFileContent(realPath.path());
            Try try_ = Try$.MODULE$.apply(() -> this.parseInternal$$anonfun$1(fileContent, fileContentProvider = new CustomFileContentProvider(this.headerFileFinder), lang = this.createParseLanguage(realPath.path()), scannerInfo = this.createScannerInfo(realPath.path())));
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                None$ none$ = None$.MODULE$;
                Some some = Some$.MODULE$.apply((Object)e);
                int n = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
                int n2 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
                parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, n, n2, (Option<Throwable>)some);
                return parseResult;
            } else {
                if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
                IASTTranslationUnit translationUnit = (IASTTranslationUnit)((Success)try_).value();
                Object[] problems = CPPVisitor.getProblems((IASTTranslationUnit)translationUnit);
                if (this.parserConfig.logProblems()) {
                    this.logProblems(Predef$.MODULE$.wrapRefArray(problems).toList());
                }
                if (this.parserConfig.logPreprocessor()) {
                    this.logPreprocessorStatements(translationUnit);
                }
                parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)Some$.MODULE$.apply((Object)translationUnit), translationUnit.getPreprocessorProblemsCount(), problems.length, CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$4());
            }
            return parseResult;
        } else {
            None$ none$ = None$.MODULE$;
            Some some = Some$.MODULE$.apply((Object)new NoSuchFileException(new StringBuilder(50).append("File '").append(realPath).append("' does not exist. Check for broken symlinks!").toString()));
            int n = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
            int n3 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
            parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, n, n3, (Option<Throwable>)some);
        }
        return parseResult;
    }

    public Iterable<IASTPreprocessorStatement> preprocessorStatements(Path file) {
        return (Iterable)this.parse(file).map((Function1 & Serializable)t -> this.preprocessorStatements((IASTTranslationUnit)t)).getOrElse(CdtParser::preprocessorStatements$$anonfun$2);
    }

    public Option<IASTTranslationUnit> parse(Path file) {
        None$ none$;
        ParseResult parseResult = this.parseInternal(file);
        ParseResult parseResult2 = parseResult;
        if (parseResult2 != null) {
            ParseResult parseResult3 = CdtParser$ParseResult$.MODULE$.unapply(parseResult2);
            Option<IASTTranslationUnit> option = parseResult3._1();
            int n = parseResult3._2();
            int n2 = parseResult3._3();
            Option<Throwable> option2 = parseResult3._4();
            if (option instanceof Some) {
                IASTTranslationUnit t = (IASTTranslationUnit)((Some)option).value();
                int c = n;
                int p = n2;
                CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.info(new StringBuilder(45).append("Parsed '").append(t.getFilePath()).append("' (").append(c).append(" preprocessor error(s), ").append(p).append(" problems)").toString());
                none$ = Some$.MODULE$.apply((Object)t);
            } else {
                Option<Throwable> maybeThrowable = option2;
                CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.warn(new StringBuilder(20).append("Failed to parse '").append(file).append("': ").append(maybeThrowable.map((Function1 & Serializable)exception -> this.extractParseException((Throwable)exception)).getOrElse(CdtParser::parse$$anonfun$2)).toString());
                none$ = None$.MODULE$;
            }
        } else {
            throw new MatchError((Object)parseResult2);
        }
        return none$;
    }

    private final IASTTranslationUnit parseInternal$$anonfun$1(FileContent fileContent$1, CustomFileContentProvider fileContentProvider$1, ILanguage lang$1, ScannerInfo scannerInfo$1) {
        return lang$1.getASTTranslationUnit(fileContent$1, (IScannerInfo)scannerInfo$1, (IncludeFileContentProvider)fileContentProvider$1, null, this.opts, (IParserLogService)this.log);
    }

    private static final Iterable preprocessorStatements$$anonfun$2() {
        return (Iterable)package$.MODULE$.Iterable().empty();
    }

    private static final String parse$$anonfun$2() {
        return "Unknown parse error!";
    }

    public static class ParseResult
    implements Product,
    Serializable {
        private final Option translationUnit;
        private final int preprocessorErrorCount;
        private final int problems;
        private final Option failure;

        public static ParseResult apply(Option<IASTTranslationUnit> option, int n, int n2, Option<Throwable> option2) {
            return CdtParser$ParseResult$.MODULE$.apply(option, n, n2, option2);
        }

        public static ParseResult fromProduct(Product product) {
            return CdtParser$ParseResult$.MODULE$.fromProduct(product);
        }

        public static ParseResult unapply(ParseResult parseResult) {
            return CdtParser$ParseResult$.MODULE$.unapply(parseResult);
        }

        public static int $lessinit$greater$default$2() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
        }

        public static int $lessinit$greater$default$3() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Throwable> $lessinit$greater$default$4() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$4();
        }

        public ParseResult(Option<IASTTranslationUnit> translationUnit, int preprocessorErrorCount, int problems, Option<Throwable> failure) {
            this.translationUnit = translationUnit;
            this.preprocessorErrorCount = preprocessorErrorCount;
            this.problems = problems;
            this.failure = failure;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.translationUnit()));
            n = Statics.mix((int)n, (int)this.preprocessorErrorCount());
            n = Statics.mix((int)n, (int)this.problems());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.failure()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseResult)) return false;
            ParseResult parseResult = (ParseResult)object;
            if (this.preprocessorErrorCount() != parseResult.preprocessorErrorCount()) return false;
            if (this.problems() != parseResult.problems()) return false;
            Option<IASTTranslationUnit> option = this.translationUnit();
            Option<IASTTranslationUnit> option2 = parseResult.translationUnit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Throwable> option3 = this.failure();
            Option<Throwable> option4 = parseResult.failure();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!parseResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseResult;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ParseResult";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "translationUnit";
                    break;
                }
                case 1: {
                    string = "preprocessorErrorCount";
                    break;
                }
                case 2: {
                    string = "problems";
                    break;
                }
                case 3: {
                    string = "failure";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Option<IASTTranslationUnit> translationUnit() {
            return this.translationUnit;
        }

        public int preprocessorErrorCount() {
            return this.preprocessorErrorCount;
        }

        public int problems() {
            return this.problems;
        }

        public Option<Throwable> failure() {
            return this.failure;
        }

        public ParseResult copy(Option<IASTTranslationUnit> translationUnit, int preprocessorErrorCount, int problems, Option<Throwable> failure) {
            return new ParseResult(translationUnit, preprocessorErrorCount, problems, failure);
        }

        public Option<IASTTranslationUnit> copy$default$1() {
            return this.translationUnit();
        }

        public int copy$default$2() {
            return this.preprocessorErrorCount();
        }

        public int copy$default$3() {
            return this.problems();
        }

        public Option<Throwable> copy$default$4() {
            return this.failure();
        }

        public Option<IASTTranslationUnit> _1() {
            return this.translationUnit();
        }

        public int _2() {
            return this.preprocessorErrorCount();
        }

        public int _3() {
            return this.problems();
        }

        public Option<Throwable> _4() {
            return this.failure();
        }
    }
}

