/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.passes;

import better.files.File$;
import io.joern.c2cpg.Config;
import io.joern.c2cpg.datastructures.CGlobal$;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.utils.IncludeAutoDiscovery$;
import io.joern.x2cpg.Ast;
import io.joern.x2cpg.Ast$;
import io.joern.x2cpg.passes.frontend.MetaDataPass$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Properties;
import io.shiftleft.codepropertygraph.generated.nodes.HasFilename;
import io.shiftleft.codepropertygraph.generated.nodes.HasIsExternal;
import io.shiftleft.codepropertygraph.generated.nodes.Local;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewFile;
import io.shiftleft.codepropertygraph.generated.nodes.NewFile$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn$;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewNode;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl$;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.codepropertygraph.generated.nodes.Type;
import io.shiftleft.passes.SimpleCpgPass;
import io.shiftleft.passes.SimpleCpgPass$;
import io.shiftleft.semanticcpg.language.types.structure.NamespaceTraversal$;
import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.BatchedUpdate;
import overflowdb.Node;
import overflowdb.NodeOrDetachedNode;
import overflowdb.traversal.NodeTraversal$;
import overflowdb.traversal.Traversal;
import overflowdb.traversal.Traversal$;
import overflowdb.traversal.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class HeaderContentPass
extends SimpleCpgPass {
    private final Cpg cpg;
    private final Set<Path> systemIncludePaths;
    private final String filename;
    private final String globalName;
    private final String fullName;
    private final Set<String> typeDeclFullNames;

    public HeaderContentPass(Cpg cpg, Config config) {
        this.cpg = cpg;
        super(cpg, SimpleCpgPass$.MODULE$.$lessinit$greater$default$2(), SimpleCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.systemIncludePaths = (Set)IncludeAutoDiscovery$.MODULE$.discoverIncludePathsC(config).$plus$plus(IncludeAutoDiscovery$.MODULE$.discoverIncludePathsCPP(config));
        String absolutePath = File$.MODULE$.apply((String)config.inputPaths().head(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).path().toAbsolutePath().normalize().toString();
        this.filename = new StringBuilder(11).append(absolutePath).append(":<includes>").toString();
        this.globalName = NamespaceTraversal$.MODULE$.globalNamespaceName();
        this.fullName = MetaDataPass$.MODULE$.getGlobalNamespaceBlockFullName((Option)Some$.MODULE$.apply((Object)this.filename));
        this.typeDeclFullNames = ((Traversal)package$.MODULE$.jIteratortoTraversal(cpg.graph().nodes("TYPE_DECL")).map((Function1 & Serializable)_$1 -> (String)_$1.property(Properties.FULL_NAME))).toSetImmutable();
    }

    private void setExternal(HasFilename node, BatchedUpdate.DiffGraphBuilder diffGraph) {
        if (node instanceof HasIsExternal && this.systemIncludePaths.exists((Function1 & Serializable)p -> node.filename().startsWith(p.toString()))) {
            diffGraph.setNodeProperty((Node)((StoredNode)node), "IS_EXTERNAL", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
    }

    private NewBlock createGlobalBlock(BatchedUpdate.DiffGraphBuilder dstGraph) {
        NewFile includesFile = NewFile$.MODULE$.apply().name(this.filename).order(0);
        NewNamespaceBlock namespaceBlock = NewNamespaceBlock$.MODULE$.apply().name(this.globalName).fullName(this.fullName).filename(this.filename).order(1);
        NewMethod fakeGlobalIncludesMethod = NewMethod$.MODULE$.apply().name(this.globalName).code(this.globalName).fullName(this.fullName).filename(this.filename).lineNumber(Predef$.MODULE$.int2Integer(1)).astParentType("NAMESPACE_BLOCK").astParentFullName(this.fullName);
        NewBlock blockNode = NewBlock$.MODULE$.apply().order(1).argumentIndex(1).typeFullName("ANY");
        NewMethodReturn methodReturn = NewMethodReturn$.MODULE$.apply().code("RET").evaluationStrategy("BY_VALUE").typeFullName("ANY").order(2);
        Ast ast = Ast$.MODULE$.apply((NewNode)includesFile).withChild(Ast$.MODULE$.apply((NewNode)namespaceBlock).withChild(Ast$.MODULE$.apply((NewNode)fakeGlobalIncludesMethod).withChild(Ast$.MODULE$.apply((NewNode)blockNode)).withChild(Ast$.MODULE$.apply((NewNode)methodReturn))));
        Ast$.MODULE$.storeInDiffGraph(ast, dstGraph);
        return blockNode;
    }

    private void createMissingAstEdges(BatchedUpdate.DiffGraphBuilder dstGraph) {
        NewBlock globalBlock = this.createGlobalBlock(dstGraph);
        Traversal$.MODULE$.apply(this.cpg.graph().nodes()).whereNot((Function1 & Serializable)_$2 -> {
            Traversal traversal = package$.MODULE$.toNodeTraversal(_$2);
            return NodeTraversal$.MODULE$.inE$extension(traversal, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AST"}));
        }).foreach((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            Node srcNode;
            Node node = x$1;
            if (node instanceof HasFilename && FileDefaults$.MODULE$.isHeaderFile(((HasFilename)(srcNode = (Node)((HasFilename)node))).filename())) {
                dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)((StoredNode)srcNode), "AST");
                this.setExternal((HasFilename)srcNode, dstGraph);
                boxedUnit = BoxedUnit.UNIT;
            } else if (node instanceof Local) {
                Local srcNode2 = (Local)node;
                boxedUnit = dstGraph.addEdge((NodeOrDetachedNode)globalBlock, (NodeOrDetachedNode)srcNode2, "AST");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private boolean typeNeedsTypeDeclStub(Type t) {
        return !this.typeDeclFullNames.contains((Object)t.typeDeclFullName());
    }

    private void createMissingTypeDecls(BatchedUpdate.DiffGraphBuilder dstGraph) {
        Traversal$.MODULE$.apply(this.cpg.graph().nodes("TYPE")).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            block0: {
                Type t;
                Node node = x$1;
                if (!(node instanceof Type) || !this.typeNeedsTypeDeclStub(t = (Type)node)) break block0;
                NewTypeDecl newTypeDecl = NewTypeDecl$.MODULE$.apply().name(t.name()).fullName(t.typeDeclFullName()).code(t.name()).isExternal(true).filename(this.filename).astParentType("NAMESPACE_BLOCK").astParentFullName(this.fullName);
                Ast$.MODULE$.storeInDiffGraph(Ast$.MODULE$.apply((NewNode)newTypeDecl), dstGraph);
            }
        });
    }

    public void run(BatchedUpdate.DiffGraphBuilder dstGraph) {
        if (CGlobal$.MODULE$.shouldBeCleared()) {
            this.createMissingAstEdges(dstGraph);
            this.createMissingTypeDecls(dstGraph);
        }
    }
}

