/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.utils;

import io.joern.c2cpg.Config;
import io.joern.c2cpg.utils.ExternalCommand$;
import java.io.Serializable;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;

public final class IncludeAutoDiscovery$
implements Serializable {
    private static final Logger logger;
    private static final boolean IS_WIN;
    private static final String GCC_VERSION_COMMAND;
    private static final String CPP_INCLUDE_COMMAND;
    private static final String C_INCLUDE_COMMAND;
    private static Option<Object> isGccAvailable;
    private static Set<Path> systemIncludePathsC;
    private static Set<Path> systemIncludePathsCPP;
    public static final IncludeAutoDiscovery$ MODULE$;

    private IncludeAutoDiscovery$() {
    }

    static {
        MODULE$ = new IncludeAutoDiscovery$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        IS_WIN = Properties$.MODULE$.isWin();
        GCC_VERSION_COMMAND = "gcc --version";
        CPP_INCLUDE_COMMAND = IS_WIN ? "gcc -xc++ -E -v . -o nul" : "gcc -xc++ -E -v /dev/null -o /dev/null";
        C_INCLUDE_COMMAND = IS_WIN ? "gcc -xc -E -v . -o nul" : "gcc -xc -E -v /dev/null -o /dev/null";
        isGccAvailable = None$.MODULE$;
        systemIncludePathsC = Predef$.MODULE$.Set().empty();
        systemIncludePathsCPP = Predef$.MODULE$.Set().empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IncludeAutoDiscovery$.class);
    }

    public String GCC_VERSION_COMMAND() {
        return GCC_VERSION_COMMAND;
    }

    private boolean checkForGcc() {
        boolean bl;
        logger.debug("Checking gcc ...");
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(this.GCC_VERSION_COMMAND());
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            logger.debug(new StringBuilder(18).append("GCC is available: ").append(result.mkString(System.lineSeparator())).toString());
            bl = true;
        } else {
            logger.warn("GCC is not installed. Discovery of system include paths will not be available.");
            bl = false;
        }
        return bl;
    }

    public boolean gccAvailable() {
        boolean bl;
        Option<Object> option = isGccAvailable;
        if (option instanceof Some) {
            boolean value;
            bl = value = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            isGccAvailable = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.checkForGcc()));
            bl = BoxesRunTime.unboxToBoolean((Object)isGccAvailable.get());
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private Set<Path> extractPaths(Seq<String> output) {
        int startIndex = output.indexWhere((Function1 & Serializable)_$1 -> _$1.contains("#include")) + 2;
        int endIndex = IS_WIN ? output.indexWhere((Function1 & Serializable)_$2 -> _$2.startsWith("End of search list.")) - 1 : output.indexWhere((Function1 & Serializable)_$3 -> _$3.startsWith("COMPILER_PATH")) - 1;
        return ((IterableOnceOps)((IterableOps)output.slice(startIndex, endIndex)).map((Function1 & Serializable)p -> Paths.get(p.trim(), new String[0]).toRealPath(new LinkOption[0]))).toSet();
    }

    private Set<Path> discoverPaths(String command) {
        Set set;
        Try<Seq<String>> try_ = ExternalCommand$.MODULE$.run(command);
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            set = this.extractPaths((Seq<String>)output);
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn(new StringBuilder(59).append("Unable to discover system include paths. Running '").append(command).append("' failed.").toString(), exception);
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(try_);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Path> discoverIncludePathsC(Config config) {
        Set set;
        if (config.includePathsAutoDiscovery() && systemIncludePathsC.nonEmpty()) {
            set = systemIncludePathsC;
        } else if (config.includePathsAutoDiscovery() && systemIncludePathsC.isEmpty() && this.gccAvailable()) {
            void var2_2;
            Set<Path> includePathsC = this.discoverPaths(C_INCLUDE_COMMAND);
            if (includePathsC.nonEmpty()) {
                logger.info(new StringBuilder(43).append("Using the following C system include paths:").append(includePathsC.mkString(new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), System.lineSeparator())).toString());
            }
            systemIncludePathsC = includePathsC;
            set = var2_2;
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Path> discoverIncludePathsCPP(Config config) {
        Set set;
        if (config.includePathsAutoDiscovery() && systemIncludePathsCPP.nonEmpty()) {
            set = systemIncludePathsCPP;
        } else if (config.includePathsAutoDiscovery() && systemIncludePathsCPP.isEmpty() && this.gccAvailable()) {
            void var2_2;
            Set<Path> includePathsCPP = this.discoverPaths(CPP_INCLUDE_COMMAND);
            if (includePathsCPP.nonEmpty()) {
                logger.info(new StringBuilder(45).append("Using the following CPP system include paths:").append(includePathsCPP.mkString(new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), new StringBuilder(2).append(System.lineSeparator()).append("- ").toString(), System.lineSeparator())).toString());
            }
            systemIncludePathsCPP = includePathsCPP;
            set = var2_2;
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }
}

