/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.utils;

import io.joern.c2cpg.utils.Report$;
import io.joern.c2cpg.utils.Report$ReportEntry$;
import io.joern.c2cpg.utils.TimeUtils$;
import java.io.Serializable;
import java.lang.constant.Constable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Report {
    private final TrieMap<String, ReportEntry> reports = TrieMap$.MODULE$.empty();

    private String formatTable(Seq<Seq<String>> table) {
        String string;
        if (table.isEmpty()) {
            string = "";
        } else {
            Seq colWidths = (Seq)((IterableOps)table.transpose(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToInt((Object)((IterableOnceOps)_$1.map((Function1 & Serializable)cell -> cell == null ? 0 : cell.length())).max((Ordering)Ordering.Int$.MODULE$)) + 2);
            Seq rows = (Seq)table.map((Function1 & Serializable)_$2 -> ((IterableOnceOps)((IterableOps)_$2.zip((IterableOnce)colWidths)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String item = (String)tuple2._1();
                int size = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(4).append(" %-").append(size - 1).append("s").toString()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{item}));
            })).mkString("|", "|", "|"));
            String separator = ((IterableOnceOps)colWidths.map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), BoxesRunTime.unboxToInt((Object)_$3)))).mkString("+", "+", "+");
            String header = (String)rows.head();
            Seq content = (Seq)((IterableOps)rows.tail()).take(((SeqOps)rows.tail()).size() - 1);
            String footer = (String)((IterableOps)rows.tail()).last();
            string = ((IterableOnceOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)((SeqOps)content.$plus$colon((Object)separator)).$plus$colon((Object)header)).$plus$colon((Object)separator)).$colon$plus((Object)separator)).$colon$plus((Object)footer)).$colon$plus((Object)separator)).mkString("\n");
        }
        return string;
    }

    public void print() {
        Seq rows = ((SeqOps)((IterableOps)this.reports.toSeq().sortBy((Function1 & Serializable)_$4 -> (String)_$4._1(), (Ordering)Ordering.String$.MODULE$)).zipWithIndex()).view().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String file = (String)tuple2._1();
            ReportEntry sum = (ReportEntry)tuple2._2();
            int index = BoxesRunTime.unboxToInt((Object)tuple22._2());
            String string = String.valueOf(BoxesRunTime.boxToInteger((int)(index + 1)));
            return (Seq)((SeqOps)sum.toSeq().$plus$colon((Object)file)).$plus$colon((Object)string);
        }).toSeq();
        int numOfReports = this.reports.size();
        Seq header = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"#", "File", "LOC", "Parsed", "Got a CPG", "Duration"}))}));
        Seq footer = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Total", "", String.valueOf(((IterableOnceOps)this.reports.map((Function1 & Serializable)_$5 -> ((ReportEntry)_$5._2()).loc())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), new StringBuilder(1).append(this.reports.count((Function1 & Serializable)_$6 -> ((ReportEntry)_$6._2()).parsed())).append("/").append(numOfReports).toString(), new StringBuilder(1).append(this.reports.count((Function1 & Serializable)_$7 -> ((ReportEntry)_$7._2()).cpgGen())).append("/").append(numOfReports).toString(), ""}))}));
        Seq table = (Seq)((IterableOps)header.$plus$plus((IterableOnce)rows)).$plus$plus((IterableOnce)footer);
        Report$.io$joern$c2cpg$utils$Report$$$logger.debug(new StringBuilder(7).append("Report:").append(System.lineSeparator()).append(this.formatTable((Seq<Seq<String>>)table)).toString());
    }

    public void addReportInfo(String fileName, int loc, boolean parsed, boolean cpgGen, long duration) {
        this.reports.update((Object)fileName, (Object)Report$ReportEntry$.MODULE$.apply(loc, parsed, cpgGen, duration));
    }

    public boolean addReportInfo$default$3() {
        return false;
    }

    public boolean addReportInfo$default$4() {
        return false;
    }

    public long addReportInfo$default$5() {
        return 0L;
    }

    public void updateReport(String fileName, boolean cpg, long duration) {
        this.reports.updateWith((Object)fileName, (Function1 & Serializable)_$8 -> _$8.map((Function1 & Serializable)_$9 -> _$9.copy(_$9.copy$default$1(), _$9.copy$default$2(), cpg, duration)));
    }

    private static class ReportEntry
    implements Product,
    Serializable {
        private final int loc;
        private final boolean parsed;
        private final boolean cpgGen;
        private final long duration;

        public static ReportEntry apply(int n, boolean bl, boolean bl2, long l) {
            return Report$ReportEntry$.MODULE$.apply(n, bl, bl2, l);
        }

        public static ReportEntry fromProduct(Product product) {
            return Report$ReportEntry$.MODULE$.fromProduct(product);
        }

        public static ReportEntry unapply(ReportEntry reportEntry) {
            return Report$ReportEntry$.MODULE$.unapply(reportEntry);
        }

        public ReportEntry(int loc, boolean parsed, boolean cpgGen, long duration) {
            this.loc = loc;
            this.parsed = parsed;
            this.cpgGen = cpgGen;
            this.duration = duration;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.loc());
            n = Statics.mix((int)n, (int)(this.parsed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.cpgGen() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.duration()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReportEntry)) return false;
            ReportEntry reportEntry = (ReportEntry)object;
            if (this.loc() != reportEntry.loc()) return false;
            if (this.parsed() != reportEntry.parsed()) return false;
            if (this.cpgGen() != reportEntry.cpgGen()) return false;
            if (this.duration() != reportEntry.duration()) return false;
            if (!reportEntry.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReportEntry;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ReportEntry";
        }

        public Object productElement(int n) {
            Constable constable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    constable = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    constable = BoxesRunTime.boxToBoolean((boolean)this._2());
                    break;
                }
                case 2: {
                    constable = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    constable = BoxesRunTime.boxToLong((long)this._4());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return constable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "loc";
                    break;
                }
                case 1: {
                    string = "parsed";
                    break;
                }
                case 2: {
                    string = "cpgGen";
                    break;
                }
                case 3: {
                    string = "duration";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int loc() {
            return this.loc;
        }

        public boolean parsed() {
            return this.parsed;
        }

        public boolean cpgGen() {
            return this.cpgGen;
        }

        public long duration() {
            return this.duration;
        }

        public Seq<String> toSeq() {
            String lines = BoxesRunTime.boxToInteger((int)this.loc()).toString();
            String dur = this.duration() == 0L ? "-" : TimeUtils$.MODULE$.pretty(this.duration());
            String wasParsed = this.parsed() ? "yes" : "no";
            String gotCpg = this.cpgGen() ? "yes" : "no";
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{lines, wasParsed, gotCpg, dur}));
        }

        public ReportEntry copy(int loc, boolean parsed, boolean cpgGen, long duration) {
            return new ReportEntry(loc, parsed, cpgGen, duration);
        }

        public int copy$default$1() {
            return this.loc();
        }

        public boolean copy$default$2() {
            return this.parsed();
        }

        public boolean copy$default$3() {
            return this.cpgGen();
        }

        public long copy$default$4() {
            return this.duration();
        }

        public int _1() {
            return this.loc();
        }

        public boolean _2() {
            return this.parsed();
        }

        public boolean _3() {
            return this.cpgGen();
        }

        public long _4() {
            return this.duration();
        }
    }
}

