/*
 * Decompiled with CFR 0.152.
 */
package io.joern.c2cpg.parser;

import better.files.File;
import better.files.File$;
import io.joern.c2cpg.Config;
import io.joern.c2cpg.parser.CdtParser$;
import io.joern.c2cpg.parser.CdtParser$ParseResult$;
import io.joern.c2cpg.parser.CustomFileContentProvider;
import io.joern.c2cpg.parser.FileDefaults$;
import io.joern.c2cpg.parser.HeaderFileFinder;
import io.joern.c2cpg.parser.ParseProblemsLogger;
import io.joern.c2cpg.parser.ParserConfig;
import io.joern.c2cpg.parser.ParserConfig$;
import io.joern.c2cpg.parser.PreprocessorStatementsLogger;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class CdtParser
implements ParseProblemsLogger,
PreprocessorStatementsLogger {
    private Logger io$joern$c2cpg$parser$ParseProblemsLogger$$logger;
    private Logger io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger;
    private final HeaderFileFinder headerFileFinder;
    private final ParserConfig parserConfig;
    private final Map<String, String> definedSymbols;
    private final Set<Path> includePaths;
    private final DefaultLogService log;
    private final int opts;

    public static FileContent readFileAsFileContent(Path path) {
        return CdtParser$.MODULE$.readFileAsFileContent(path);
    }

    public CdtParser(Config config) {
        ParseProblemsLogger.$init$(this);
        PreprocessorStatementsLogger.$init$(this);
        this.headerFileFinder = new HeaderFileFinder(config.inputPath());
        this.parserConfig = ParserConfig$.MODULE$.fromConfig(config);
        this.definedSymbols = CollectionConverters$.MODULE$.MapHasAsJava(this.parserConfig.definedSymbols()).asJava();
        this.includePaths = this.parserConfig.userIncludePaths();
        this.log = new DefaultLogService();
        this.opts = 32;
        Statics.releaseFence();
    }

    @Override
    public Logger io$joern$c2cpg$parser$ParseProblemsLogger$$logger() {
        return this.io$joern$c2cpg$parser$ParseProblemsLogger$$logger;
    }

    @Override
    public void io$joern$c2cpg$parser$ParseProblemsLogger$_setter_$io$joern$c2cpg$parser$ParseProblemsLogger$$logger_$eq(Logger x$0) {
        this.io$joern$c2cpg$parser$ParseProblemsLogger$$logger = x$0;
    }

    @Override
    public Logger io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger() {
        return this.io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger;
    }

    @Override
    public void io$joern$c2cpg$parser$PreprocessorStatementsLogger$_setter_$io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger_$eq(Logger x$0) {
        this.io$joern$c2cpg$parser$PreprocessorStatementsLogger$$logger = x$0;
    }

    private ILanguage createParseLanguage(Path file) {
        if (FileDefaults$.MODULE$.isCPPFile(file.toString())) {
            return GPPLanguage.getDefault();
        }
        return GCCLanguage.getDefault();
    }

    private ScannerInfo createScannerInfo(Path file) {
        Set<Path> additionalIncludes = FileDefaults$.MODULE$.isCPPFile(file.toString()) ? this.parserConfig.systemIncludePathsCPP() : this.parserConfig.systemIncludePathsC();
        return new ScannerInfo(this.definedSymbols, (String[])((IterableOnceOps)this.includePaths.$plus$plus(additionalIncludes).map((Function1 & Serializable)_$1 -> _$1.toString())).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private ParseResult parseInternal(Path file) {
        File realPath = File$.MODULE$.apply(file);
        if (realPath.isRegularFile(realPath.isRegularFile$default$1())) {
            ParseResult parseResult;
            try {
                FileContent fileContent = CdtParser$.MODULE$.readFileAsFileContent(realPath.path());
                CustomFileContentProvider fileContentProvider = new CustomFileContentProvider(this.headerFileFinder);
                ILanguage lang = this.createParseLanguage(realPath.path());
                ScannerInfo scannerInfo = this.createScannerInfo(realPath.path());
                IASTTranslationUnit translationUnit = lang.getASTTranslationUnit(fileContent, (IScannerInfo)scannerInfo, (IncludeFileContentProvider)fileContentProvider, null, this.opts, (IParserLogService)this.log);
                Object[] problems = CPPVisitor.getProblems((IASTTranslationUnit)translationUnit);
                if (this.parserConfig.logProblems()) {
                    this.logProblems(Predef$.MODULE$.wrapRefArray(problems).toList());
                }
                if (this.parserConfig.logPreprocessor()) {
                    this.logPreprocessorStatements(translationUnit);
                }
                parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)Option$.MODULE$.apply((Object)translationUnit), translationUnit.getPreprocessorProblemsCount(), problems.length, CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$4());
            }
            catch (UnsupportedClassVersionError u) {
                CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.error("c2cpg requires at least JRE-17 to run. Please check your Java Runtime Environment!", (Throwable)u);
                System.exit(1);
                None$ none$ = None$.MODULE$;
                Option option = Option$.MODULE$.apply((Object)u);
                int n = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
                int n2 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
                parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, n, n2, (Option<Throwable>)option);
            }
            catch (Throwable e) {
                None$ none$ = None$.MODULE$;
                Option option = Option$.MODULE$.apply((Object)e);
                int n = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
                int n3 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
                parseResult = CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, n, n3, (Option<Throwable>)option);
            }
            return parseResult;
        }
        None$ none$ = None$.MODULE$;
        Option option = Option$.MODULE$.apply((Object)new NoSuchFileException("File '" + realPath + "' does not exist. Check for broken symlinks!"));
        int n = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
        int n4 = CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
        return CdtParser$ParseResult$.MODULE$.apply((Option<IASTTranslationUnit>)none$, n, n4, (Option<Throwable>)option);
    }

    public Iterable<IASTPreprocessorStatement> preprocessorStatements(Path file) {
        return (Iterable)this.parse(file).map((Function1 & Serializable)t -> this.preprocessorStatements((IASTTranslationUnit)t)).getOrElse(CdtParser::preprocessorStatements$$anonfun$2);
    }

    public Option<IASTTranslationUnit> parse(Path file) {
        ParseResult parseResult = this.parseInternal(file);
        ParseResult parseResult2 = parseResult;
        if (parseResult2 != null) {
            ParseResult parseResult3 = CdtParser$ParseResult$.MODULE$.unapply(parseResult2);
            Option<IASTTranslationUnit> option = parseResult3._1();
            int n = parseResult3._2();
            int n2 = parseResult3._3();
            Option<Throwable> option2 = parseResult3._4();
            if (option instanceof Some) {
                IASTTranslationUnit t = (IASTTranslationUnit)((Some)option).value();
                int c = n;
                int p = n2;
                CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.info("Parsed '" + t.getFilePath() + "' (" + c + " preprocessor error(s), " + p + " problems)");
                return Option$.MODULE$.apply((Object)t);
            }
            Option<Throwable> maybeThrowable = option2;
            CdtParser$.io$joern$c2cpg$parser$CdtParser$$$logger.warn("Failed to parse '" + file + "': " + maybeThrowable.map((Function1 & Serializable)exception -> this.extractParseException((Throwable)exception)).getOrElse(CdtParser::parse$$anonfun$2));
            return None$.MODULE$;
        }
        throw new MatchError((Object)parseResult2);
    }

    private static final Iterable preprocessorStatements$$anonfun$2() {
        return (Iterable)package$.MODULE$.Iterable().empty();
    }

    private static final String parse$$anonfun$2() {
        return "Unknown parse error!";
    }

    public static class ParseResult
    implements Product,
    Serializable {
        private final Option translationUnit;
        private final int preprocessorErrorCount;
        private final int problems;
        private final Option failure;

        public static ParseResult apply(Option<IASTTranslationUnit> option, int n, int n2, Option<Throwable> option2) {
            return CdtParser$ParseResult$.MODULE$.apply(option, n, n2, option2);
        }

        public static ParseResult fromProduct(Product product) {
            return CdtParser$ParseResult$.MODULE$.fromProduct(product);
        }

        public static ParseResult unapply(ParseResult parseResult) {
            return CdtParser$ParseResult$.MODULE$.unapply(parseResult);
        }

        public static int $lessinit$greater$default$2() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$2();
        }

        public static int $lessinit$greater$default$3() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Throwable> $lessinit$greater$default$4() {
            return CdtParser$ParseResult$.MODULE$.$lessinit$greater$default$4();
        }

        public ParseResult(Option<IASTTranslationUnit> translationUnit, int preprocessorErrorCount, int problems, Option<Throwable> failure) {
            this.translationUnit = translationUnit;
            this.preprocessorErrorCount = preprocessorErrorCount;
            this.problems = problems;
            this.failure = failure;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.translationUnit()));
            n = Statics.mix((int)n, (int)this.preprocessorErrorCount());
            n = Statics.mix((int)n, (int)this.problems());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.failure()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseResult)) return false;
            ParseResult parseResult = (ParseResult)object;
            if (this.preprocessorErrorCount() != parseResult.preprocessorErrorCount()) return false;
            if (this.problems() != parseResult.problems()) return false;
            Option<IASTTranslationUnit> option = this.translationUnit();
            Option<IASTTranslationUnit> option2 = parseResult.translationUnit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Throwable> option3 = this.failure();
            Option<Throwable> option4 = parseResult.failure();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!parseResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseResult;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ParseResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "translationUnit";
                }
                case 1: {
                    return "preprocessorErrorCount";
                }
                case 2: {
                    return "problems";
                }
                case 3: {
                    return "failure";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<IASTTranslationUnit> translationUnit() {
            return this.translationUnit;
        }

        public int preprocessorErrorCount() {
            return this.preprocessorErrorCount;
        }

        public int problems() {
            return this.problems;
        }

        public Option<Throwable> failure() {
            return this.failure;
        }

        public ParseResult copy(Option<IASTTranslationUnit> translationUnit, int preprocessorErrorCount, int problems, Option<Throwable> failure) {
            return new ParseResult(translationUnit, preprocessorErrorCount, problems, failure);
        }

        public Option<IASTTranslationUnit> copy$default$1() {
            return this.translationUnit();
        }

        public int copy$default$2() {
            return this.preprocessorErrorCount();
        }

        public int copy$default$3() {
            return this.problems();
        }

        public Option<Throwable> copy$default$4() {
            return this.failure();
        }

        public Option<IASTTranslationUnit> _1() {
            return this.translationUnit();
        }

        public int _2() {
            return this.preprocessorErrorCount();
        }

        public int _3() {
            return this.problems();
        }

        public Option<Throwable> _4() {
            return this.failure();
        }
    }
}

