/*
 * Decompiled with CFR 0.152.
 */
package io.joern.csharpsrc2cpg.utils;

import better.files.File;
import better.files.File$;
import io.joern.csharpsrc2cpg.Config;
import io.joern.csharpsrc2cpg.datastructures.CSharpProgramSummary;
import io.joern.csharpsrc2cpg.datastructures.CSharpProgramSummary$;
import io.joern.csharpsrc2cpg.datastructures.CSharpType;
import io.joern.csharpsrc2cpg.utils.DependencyDownloader$;
import io.joern.csharpsrc2cpg.utils.DependencyDownloader$NuGetPackageVersions$;
import io.joern.csharpsrc2cpg.utils.DotNetAstGenRunner;
import io.joern.x2cpg.astgen.AstGenRunner;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Dependency;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import ujson.Readable;
import ujson.Readable$;
import upickle.default$;

public class DependencyDownloader {
    private final Cpg cpg;
    private final Config config;
    private final CSharpProgramSummary internalProgramSummary;
    private final scala.collection.immutable.Set<String> internalPackages;
    private final Logger logger;
    private final String NUGET_BASE_API_V2;
    private final String NUGET_BASE_API_V3;
    public final DependencyDownloader$NuGetPackageVersions$ NuGetPackageVersions$lzy1;

    public static scala.collection.immutable.Set<String> $lessinit$greater$default$4() {
        return DependencyDownloader$.MODULE$.$lessinit$greater$default$4();
    }

    public DependencyDownloader(Cpg cpg, Config config, CSharpProgramSummary internalProgramSummary, scala.collection.immutable.Set<String> internalPackages) {
        this.cpg = cpg;
        this.config = config;
        this.internalProgramSummary = internalProgramSummary;
        this.internalPackages = internalPackages;
        this.NuGetPackageVersions$lzy1 = new DependencyDownloader$NuGetPackageVersions$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.NUGET_BASE_API_V2 = "www.nuget.org/api/v2";
        this.NUGET_BASE_API_V3 = "api.nuget.org/v3-flatcontainer";
    }

    public CSharpProgramSummary download() {
        return (CSharpProgramSummary)File$.MODULE$.temporaryDirectory("joern-csharpsrc2cpg", File$.MODULE$.temporaryDirectory$default$2(), File$.MODULE$.temporaryDirectory$default$3()).apply((Function1 & Serializable)dir -> {
            io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg).dependency().filterNot((Function1 & Serializable)dependency -> this.isAlreadySummarized((Dependency)dependency)).foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.downloadDependency((File)dir, (Dependency)_$1));
            this.unzipDependencies((File)dir);
            return this.summarizeDependencies((File)dir).appendAll(this.internalProgramSummary);
        });
    }

    private boolean isAlreadySummarized(Dependency dependency) {
        return this.internalProgramSummary.namespaceToType().keySet().exists((Function1 & Serializable)_$2 -> _$2.startsWith(dependency.name())) || this.internalPackages.contains((Object)dependency.name());
    }

    private final DependencyDownloader$NuGetPackageVersions$ NuGetPackageVersions() {
        return this.NuGetPackageVersions$lzy1;
    }

    private void downloadDependency(File targetDir, Dependency dependency) {
        String dependencyName = dependency.name().strip();
        Option versionOpt = dependency.version().isBlank() ? this.getVersion$1(dependencyName) : Option$.MODULE$.apply((Object)dependency.version());
        Option option = versionOpt;
        if (option instanceof Some) {
            String version = (String)((Some)option).value();
            this.downloadPackage(targetDir, dependency, this.createUrl$1(dependencyName, "package", version));
            this.downloadPackage(targetDir, dependency, this.createUrl$1(dependencyName, "symbolpackage", version));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger.error("Unable to determine package version for " + dependencyName + ", skipping");
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Unable to fully structure code
     */
    private void downloadPackage(File targetDir, Dependency dependency, URL url) {
        block13: {
            connection = None$.MODULE$;
            try {
                try {
                    block14: {
                        connection = Option$.MODULE$.apply((Object)url.openConnection()).collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(URLConnection x) {
                                URLConnection uRLConnection = x;
                                if (uRLConnection instanceof HttpURLConnection) {
                                    HttpURLConnection x2 = (HttpURLConnection)uRLConnection;
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(URLConnection x, Function1 function1) {
                                URLConnection uRLConnection = x;
                                if (uRLConnection instanceof HttpURLConnection) {
                                    HttpURLConnection x2 = (HttpURLConnection)uRLConnection;
                                    return x2;
                                }
                                return function1.apply((Object)x);
                            }
                        });
                        connection.foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, downloadPackage$$anonfun$1(java.net.HttpURLConnection ), (Ljava/net/HttpURLConnection;)V)());
                        var5_5 = connection;
                        if (!(var5_5 instanceof Some) || (var6_6 = (HttpURLConnection)((Some)var5_5).value()) == null) break block14;
                        var7_7 = var6_6;
                        conn = var7_7;
                        if (conn.getResponseCode() != 200) ** GOTO lbl35
                        ext = url.toString().contains("/package/") != false ? "nupkg" : "snupkg";
                        fileName = targetDir.$div(dependency.name() + "." + ext);
                        var12_11 = Option$.MODULE$.apply((Object)conn.getContentEncoding());
                        if (!(var12_11 instanceof Some)) ** GOTO lbl-1000
                        var13_12 = (String)((Some)var12_11).value();
                        encoding = var13_12;
                        if (encoding.equalsIgnoreCase("gzip")) {
                            v0 = new GZIPInputStream(conn.getInputStream());
                        } else {
                            encoding = var13_12;
                            if (encoding.equalsIgnoreCase("deflate")) {
                                v0 = new InflaterInputStream(conn.getInputStream());
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = conn.getInputStream();
                            }
                        }
                        inputStream = v0;
                        var16_16 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$adapted$1(java.io.InputStream better.files.File ), ()Ljava/lang/Object;)((InputStream)inputStream, (File)fileName));
                        if (var16_16 instanceof Failure) {
                            exception = ((Failure)var16_16).exception();
                            this.logger.error("Exception occurred while downloading " + fileName + " (" + dependency.name() + ":" + dependency.version() + ")", exception);
                        } else if (var16_16 instanceof Success) {
                            this.logger.info("Successfully downloaded dependency " + dependency.name() + ":" + dependency.version());
                        } else {
                            throw new MatchError((Object)var16_16);
lbl35:
                            // 1 sources

                            conn = var7_7;
                            this.logger.error("Connection to " + url + " responded with non-200 code " + conn.getResponseCode());
                        }
                        break block13;
                    }
                    this.logger.error("Unknown URL connection made, aborting");
                }
                catch (Throwable exception) {
                    this.logger.error("Unable to download dependency " + dependency.name() + ":" + dependency.version(), exception);
                }
            }
            finally {
                connection.foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, downloadPackage$$anonfun$3(java.net.HttpURLConnection ), (Ljava/net/HttpURLConnection;)V)());
            }
        }
    }

    private void unzipDependencies(File targetDir) {
        targetDir.list().foreach((Function1 & Serializable)pkg -> {
            Function1 & Serializable intersect = (Function1 & Serializable)zipEntry -> DependencyDownloader.zipFilter$2(zipEntry);
            pkg.unzipTo(targetDir, (Function1)intersect, pkg.unzipTo$default$3(targetDir, (Function1)intersect));
            return pkg.delete(true, pkg.delete$default$2());
        });
        File libDir = targetDir.$div("lib");
        if (libDir.isDirectory(libDir.isDirectory$default$1())) {
            libDir.listRecursively(libDir.listRecursively$default$1()).filterNot((Function1 & Serializable)_$7 -> _$7.isDirectory(_$7.isDirectory$default$1())).distinctBy((Function1 & Serializable)_$8 -> _$8.name()).foreach((Function1 & Serializable)f -> {
                File file = targetDir.$div(f.name());
                boolean bl = f.copyTo$default$2();
                return f.copyTo(file, bl, f.copyTo$default$3(file, bl));
            });
            libDir.delete(true, libDir.delete$default$2());
            return;
        }
    }

    private CSharpProgramSummary summarizeDependencies(File targetDir) {
        DotNetAstGenRunner astGenRunner = new DotNetAstGenRunner((Config)this.config.withInputPath(targetDir.pathAsString()));
        AstGenRunner.AstGenRunnerResult astGenRunnerResult = astGenRunner.execute(targetDir);
        List summaries = astGenRunnerResult.parsedFiles().map((Function1 & Serializable)x -> File$.MODULE$.apply(x, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).flatMap((Function1 & Serializable)f -> (IterableOnce)Using$.MODULE$.resource((Object)f.newFileInputStream(), (Function1 & Serializable)fis -> {
            Try<Map<String, Set<CSharpType>>> try_ = CSharpProgramSummary$.MODULE$.jsonToInitialMapping((InputStream)fis);
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.error("Unable to parse JSON program summary at " + f, exception);
                return None$.MODULE$;
            }
            if (try_ instanceof Success) {
                Map parsedJson = (Map)((Success)try_).value();
                return Option$.MODULE$.apply((Object)parsedJson);
            }
            throw new MatchError(try_);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$)).map((Function1 & Serializable)_$9 -> CSharpProgramSummary$.MODULE$.apply((Map<String, Set<CSharpType>>)_$9, CSharpProgramSummary$.MODULE$.apply$default$2()));
        return CSharpProgramSummary$.MODULE$.apply((Iterable<CSharpProgramSummary>)summaries);
    }

    public static final /* synthetic */ String io$joern$csharpsrc2cpg$utils$DependencyDownloader$$anon$1$$_$allKeysArray$$anonfun$1(Tuple2 _$1) {
        return (String)_$1._2();
    }

    private static final boolean $anon$superArg$1$1$$anonfun$1(default$ ReadersVersionSpecific_this$3) {
        return ReadersVersionSpecific_this$3.allowUnknownKeys();
    }

    public static final boolean io$joern$csharpsrc2cpg$utils$DependencyDownloader$NuGetPackageVersions$$$_$_$$anon$superArg$1$1(default$ ReadersVersionSpecific_this$2) {
        return BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.Nil().headOption().getOrElse(() -> DependencyDownloader.$anon$superArg$1$1$$anonfun$1(ReadersVersionSpecific_this$2)));
    }

    private final NuGetPackageVersions getVersion$1$$anonfun$1$$anonfun$1$$anonfun$1(InputStream is$1) {
        return (NuGetPackageVersions)default$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(is$1.readAllBytes()), default$.MODULE$.read$default$2(), this.NuGetPackageVersions().derived$ReadWriter());
    }

    private final Option getVersion$1$$anonfun$1(String packageName$1) {
        return (Option)Using$.MODULE$.resource((Object)new URI("https://" + this.NUGET_BASE_API_V3 + "/" + packageName$1.toLowerCase() + "/index.json").toURL().openStream(), (Function1 & Serializable)is -> Try$.MODULE$.apply(() -> this.getVersion$1$$anonfun$1$$anonfun$1$$anonfun$1(is)).toOption().flatMap((Function1 & Serializable)_$3 -> _$3.versions().lastOption()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private final Option getVersion$1(String packageName) {
        Try try_ = Try$.MODULE$.apply(() -> this.getVersion$1$$anonfun$1(packageName));
        if (try_ instanceof Failure) {
            this.logger.error("Unable to resolve `index.json` for `" + packageName + "`, skipping...`");
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            Option x = (Option)((Success)try_).value();
            return x;
        }
        throw new MatchError((Object)try_);
    }

    private final URL createUrl$1(String dependencyName$1, String packageType, String version) {
        return new URI("https://" + this.NUGET_BASE_API_V2 + "/" + packageType + "/" + dependencyName$1 + "/" + version).toURL();
    }

    private static final /* synthetic */ void downloadPackage$$anonfun$1(HttpURLConnection _$4) {
        _$4.setRequestProperty("Accept-Encoding", "gzip, deflate");
    }

    private static final FileOutputStream downloadPackage$$anonfun$2$$anonfun$1(File fileName$2) {
        return new FileOutputStream(fileName$2.pathAsString());
    }

    private static final int downloadPackage$$anonfun$2$$anonfun$2$$anonfun$1(InputStream is$2, byte[] buffer$1) {
        return is$2.read(buffer$1);
    }

    private static final void downloadPackage$$anonfun$2(InputStream inputStream$1, File fileName$1) {
        Using$.MODULE$.resources((Object)inputStream$1, () -> DependencyDownloader.downloadPackage$$anonfun$2$$anonfun$1(fileName$1), (Function2)(JProcedure2 & Serializable)(is, fos) -> {
            byte[] buffer = new byte[4096];
            package$.MODULE$.Iterator().continually(() -> DependencyDownloader.downloadPackage$$anonfun$2$$anonfun$2$$anonfun$1(is, buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$5 -> _$5 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)bytesRead -> fos.write(buffer, 0, bytesRead));
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private static /* bridge */ /* synthetic */ Object $anonfun$adapted$1(InputStream inputStream$2, File fileName$3) {
        DependencyDownloader.downloadPackage$$anonfun$2(inputStream$2, fileName$3);
        return BoxedUnit.UNIT;
    }

    private static final /* synthetic */ void downloadPackage$$anonfun$3(HttpURLConnection _$6) {
        _$6.disconnect();
    }

    private static final boolean zipFilter$2(ZipEntry zipEntry) {
        boolean isZipSlip = zipEntry.getName().contains("..");
        return !isZipSlip && (zipEntry.isDirectory() || zipEntry.getName().matches(".*lib.*\\.(dll|xml|pdb)$"));
    }

    public class NuGetPackageVersions
    implements Product,
    Serializable {
        private final List<String> versions;
        private final /* synthetic */ DependencyDownloader $outer;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DependencyDownloader$NuGetPackageVersions$.class.getDeclaredField("derived$ReadWriter$lzy1"));

        public NuGetPackageVersions(DependencyDownloader $outer, List<String> versions) {
            this.versions = versions;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NuGetPackageVersions)) return false;
            if (((NuGetPackageVersions)object).io$joern$csharpsrc2cpg$utils$DependencyDownloader$NuGetPackageVersions$$$outer() != this.$outer) return false;
            NuGetPackageVersions nuGetPackageVersions = (NuGetPackageVersions)object;
            List<String> list = this.versions();
            List<String> list2 = nuGetPackageVersions.versions();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!nuGetPackageVersions.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NuGetPackageVersions;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NuGetPackageVersions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "versions";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<String> versions() {
            return this.versions;
        }

        public NuGetPackageVersions copy(List<String> versions) {
            return new NuGetPackageVersions(this.$outer, versions);
        }

        public List<String> copy$default$1() {
            return this.versions();
        }

        public List<String> _1() {
            return this.versions();
        }

        public final /* synthetic */ DependencyDownloader io$joern$csharpsrc2cpg$utils$DependencyDownloader$NuGetPackageVersions$$$outer() {
            return this.$outer;
        }
    }
}

