/*
 * Decompiled with CFR 0.152.
 */
package io.joern.dataflowengineoss.queryengine;

import io.joern.dataflowengineoss.queryengine.Engine$;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.dataflowengineoss.queryengine.PathElement;
import io.joern.dataflowengineoss.queryengine.ReachableByResult;
import io.joern.dataflowengineoss.queryengine.ReachableByTask;
import io.joern.dataflowengineoss.queryengine.ReachableByTask$;
import io.joern.dataflowengineoss.queryengine.ResultTable;
import io.joern.dataflowengineoss.queryengine.ResultTable$;
import io.joern.dataflowengineoss.queryengine.TaskCreator;
import io.joern.dataflowengineoss.queryengine.TaskSolver;
import io.joern.dataflowengineoss.semanticsloader.FlowSemantic;
import io.joern.dataflowengineoss.semanticsloader.Semantics;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import java.io.Serializable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.traversal.Traversal;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.collection.mutable.Stack;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\u0010!\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001a\u0001\n\u0013)\u0005bB%\u0001\u0001\u0004%IA\u0013\u0005\u0007!\u0002\u0001\u000b\u0015\u0002$\t\u000fE\u0003!\u0019!C\u0005%\"1Q\f\u0001Q\u0001\nMCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004s\u0001\u0001\u0006I\u0001\u0019\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006k\u0002!\tA\u001e\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u0015\u0001\t\u0013\t\u0019fB\u0004\u0002Z\u0001B\t!a\u0017\u0007\r}\u0001\u0003\u0012AA/\u0011\u0019)$\u0003\"\u0001\u0002`!9\u0011\u0011\r\n\u0005\u0002\u0005\r\u0004bBAD%\u0011%\u0011\u0011\u0012\u0005\b\u0003K\u0013B\u0011AAT\u0011\u001d\tiL\u0005C\u0005\u0003\u007fCq!!3\u0013\t\u0003\tY\rC\u0004\u0002bJ!\t!a9\t\u000f\u0005=(\u0003\"\u0001\u0002r\"9\u0011Q \n\u0005\u0002\u0005}\bb\u0002B\u0002%\u0011\u0005!Q\u0001\u0005\b\u0005\u001b\u0011B\u0011\u0001B\b\u0011\u001d\u0011yB\u0005C\u0001\u0005C\u0011a!\u00128hS:,'BA\u0011#\u0003-\tX/\u001a:zK:<\u0017N\\3\u000b\u0005\r\"\u0013!\u00053bi\u00064Gn\\<f]\u001eLg.Z8tg*\u0011QEJ\u0001\u0006U>,'O\u001c\u0006\u0002O\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VMZ\u0001\bG>tG/\u001a=u!\t\u00114'D\u0001!\u0013\t!\u0004EA\u0007F]\u001eLg.Z\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005]B\u0004C\u0001\u001a\u0001\u0011\u0015\u0001$\u00011\u00012\u0003\u0019awnZ4feV\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005)1\u000f\u001c45U*\t\u0001)A\u0002pe\u001eL!AQ\u001f\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nAC\\;nE\u0016\u0014xJ\u001a+bg.\u001c(+\u001e8oS:<W#\u0001$\u0011\u0005-:\u0015B\u0001%-\u0005\rIe\u000e^\u0001\u0019]Vl'-\u001a:PMR\u000b7o[:Sk:t\u0017N\\4`I\u0015\fHCA&O!\tYC*\u0003\u0002NY\t!QK\\5u\u0011\u001dye!!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003UqW/\u001c2fe>3G+Y:lgJ+hN\\5oO\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002'B\u0011AkW\u0007\u0002+*\u0011akV\u0001\u000bG>t7-\u001e:sK:$(B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011A,\u0016\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u0001R\r_3dkR|'oU3sm&\u001cW\rI\u0001\u0012G>l\u0007\u000f\\3uS>t7+\u001a:wS\u000e,W#\u00011\u0011\u0007Q\u000b7-\u0003\u0002c+\nIR\t_3dkR|'oQ8na2,G/[8o'\u0016\u0014h/[2f!\r!Gn\u001c\b\u0003K*t!AZ5\u000e\u0003\u001dT!\u0001\u001b\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013BA6-\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001c8\u0003\rY+7\r^8s\u0015\tYG\u0006\u0005\u00023a&\u0011\u0011\u000f\t\u0002\u0012%\u0016\f7\r[1cY\u0016\u0014\u0015PU3tk2$\u0018AE2p[BdW\r^5p]N+'O^5dK\u0002\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002\u0017\u0006I!-Y2lo\u0006\u0014Hm\u001d\u000b\u0005oj\f\u0019\u0002E\u0002eq>L!!\u001f8\u0003\t1K7\u000f\u001e\u0005\u0006w6\u0001\r\u0001`\u0001\u0006g&t7n\u001d\t\u0004Ibl\bc\u0001@\u0002\u00105\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011!\u00028pI\u0016\u001c(\u0002BA\u0003\u0003\u000f\t\u0011bZ3oKJ\fG/\u001a3\u000b\t\u0005%\u00111B\u0001\u0012G>$W\r\u001d:pa\u0016\u0014H/_4sCBD'bAA\u0007M\u0005I1\u000f[5gi2,g\r^\u0005\u0004\u0003#y(aB\"gO:{G-\u001a\u0005\u0007\u0003+i\u0001\u0019\u0001?\u0002\u000fM|WO]2fg\u0006!2M]3bi\u0016|e.\u001a+bg.\u0004VM]*j].$b!a\u0007\u00020\u0005\r\u0003CBA\u000f\u0003O\tI#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003%IW.\\;uC\ndWMC\u0002\u0002&1\n!bY8mY\u0016\u001cG/[8o\u0013\rI\u0018q\u0004\t\u0004e\u0005-\u0012bAA\u0017A\ty!+Z1dQ\u0006\u0014G.\u001a\"z)\u0006\u001c8\u000eC\u0004\u000229\u0001\r!a\r\u0002\u0015M|WO]2fgN+G\u000fE\u0003\u00026\u0005uRP\u0004\u0003\u00028\u0005e\u0002C\u00014-\u0013\r\tY\u0004L\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0012\u0011\t\u0002\u0004'\u0016$(bAA\u001eY!)1P\u0004a\u0001y\u0006Q1o\u001c7wKR\u000b7o[:\u0015\u000b]\fI%a\u0014\t\u000f\u0005-s\u00021\u0001\u0002N\u0005)A/Y:lgB!A\r_A\u0015\u0011\u001d\t)b\u0004a\u0001\u0003g\t!b];c[&$H+Y:l)\rY\u0015Q\u000b\u0005\b\u0003/\u0002\u0002\u0019AA\u0015\u0003\u0011!\u0018m]6\u0002\r\u0015sw-\u001b8f!\t\u0011$c\u0005\u0002\u0013UQ\u0011\u00111L\u0001\tKb\u0004\u0018M\u001c3J]R1\u0011QMA@\u0003\u0007#B!a\u001a\u0002pA!A\r\\A5!\r\u0011\u00141N\u0005\u0004\u0003[\u0002#a\u0003)bi\",E.Z7f]RDq!!\u001d\u0015\u0001\b\t\u0019(A\u0005tK6\fg\u000e^5dgB!\u0011QOA>\u001b\t\t9HC\u0002\u0002z\t\nqb]3nC:$\u0018nY:m_\u0006$WM]\u0005\u0005\u0003{\n9HA\u0005TK6\fg\u000e^5dg\"1\u0011\u0011\u0011\u000bA\u0002u\fqaY;s\u001d>$W\rC\u0004\u0002\u0006R\u0001\r!a\u001a\u0002\tA\fG\u000f[\u0001\fK2,WNR8s\u000b\u0012<W\r\u0006\u0003\u0002\f\u0006UE\u0003BAG\u0003'\u0003RaKAH\u0003SJ1!!%-\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011O\u000bA\u0004\u0005M\u0004bBAL+\u0001\u0007\u0011\u0011T\u0001\u0002KB!\u00111TAQ\u001b\t\tiJ\u0003\u0002\u0002 \u0006QqN^3sM2|w\u000f\u001a2\n\t\u0005\r\u0016Q\u0014\u0002\u0005\u000b\u0012<W-A\u000ejg>+H\u000f];u\u0003J<wJZ%oi\u0016\u0014h.\u00197NKRDw\u000e\u001a\u000b\u0005\u0003S\u000b\u0019\f\u0006\u0003\u0002,\u0006E\u0006cA\u0016\u0002.&\u0019\u0011q\u0016\u0017\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u000f\fA\u0004\u0005M\u0004bBA[-\u0001\u0007\u0011qW\u0001\u0004CJ<\u0007c\u0001@\u0002:&\u0019\u00111X@\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004eI\u001eLe.\u0012\u000b\u0007\u0003\u0003\f\u0019-a2\u0011\t\u0011d\u0017\u0011\u0014\u0005\u0007\u0003\u000b<\u0002\u0019A?\u0002\t9|G-\u001a\u0005\b\u0003\u000b;\u0002\u0019AA4\u0003E\t'o\u001a+p\u001fV$\b/\u001e;QCJ\fWn\u001d\u000b\u0005\u0003\u001b\fy\u000e\u0005\u0004\u0002P\u0006U\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002\u001e\u0006IAO]1wKJ\u001c\u0018\r\\\u0005\u0005\u0003/\f\tNA\u0005Ue\u00064XM]:bYB\u0019a0a7\n\u0007\u0005uwP\u0001\nNKRDw\u000e\u001a)be\u0006lW\r^3s\u001fV$\bbBA[1\u0001\u0007\u0011qW\u0001\rCJ<Gk\\'fi\"|Gm\u001d\u000b\u0005\u0003K\fi\u000f\u0005\u0003eq\u0006\u001d\bc\u0001@\u0002j&\u0019\u00111^@\u0003\r5+G\u000f[8e\u0011\u001d\t),\u0007a\u0001\u0003o\u000ba\"\\3uQ>$7OR8s\u0007\u0006dG\u000e\u0006\u0003\u0002f\u0006M\bbBA{5\u0001\u0007\u0011q_\u0001\u0005G\u0006dG\u000eE\u0002\u007f\u0003sL1!a?\u0000\u0005\u0011\u0019\u0015\r\u001c7\u0002-%\u001c8)\u00197m)>Le\u000e^3s]\u0006dW*\u001a;i_\u0012$B!a+\u0003\u0002!9\u0011Q_\u000eA\u0002\u0005]\u0018!J5t\u0007\u0006dG\u000eV8J]R,'O\\1m\u001b\u0016$\bn\u001c3XSRDw.\u001e;TK6\fg\u000e^5d)\u0011\u00119Aa\u0003\u0015\t\u0005-&\u0011\u0002\u0005\b\u0003cb\u00029AA:\u0011\u001d\t)\u0010\ba\u0001\u0003o\f\u0001c]3nC:$\u0018nY:G_J\u001c\u0015\r\u001c7\u0015\t\tE!Q\u0004\u000b\u0005\u0005'\u0011Y\u0002\u0005\u0003eq\nU\u0001\u0003BA;\u0005/IAA!\u0007\u0002x\taa\t\\8x'\u0016l\u0017M\u001c;jG\"9\u0011\u0011O\u000fA\u0004\u0005M\u0004bBA{;\u0001\u0007\u0011q_\u0001\fI\u0016$W\u000f\u001d7jG\u0006$X\rF\u0002d\u0005GAaA!\n\u001f\u0001\u0004\u0019\u0017a\u0001<fG\u0002")
public class Engine {
    private final EngineContext context;
    private final Logger logger;
    private int numberOfTasksRunning;
    private final ExecutorService executorService;
    private final ExecutorCompletionService<Vector<ReachableByResult>> completionService;

    public static Vector<ReachableByResult> deduplicate(Vector<ReachableByResult> vec) {
        return Engine$.MODULE$.deduplicate(vec);
    }

    public static List<FlowSemantic> semanticsForCall(Call call, Semantics semantics) {
        return Engine$.MODULE$.semanticsForCall(call, semantics);
    }

    public static boolean isCallToInternalMethodWithoutSemantic(Call call, Semantics semantics) {
        return Engine$.MODULE$.isCallToInternalMethodWithoutSemantic(call, semantics);
    }

    public static boolean isCallToInternalMethod(Call call) {
        return Engine$.MODULE$.isCallToInternalMethod(call);
    }

    public static List<Method> methodsForCall(Call call) {
        return Engine$.MODULE$.methodsForCall(call);
    }

    public static List<Method> argToMethods(Expression arg) {
        return Engine$.MODULE$.argToMethods(arg);
    }

    public static Traversal<MethodParameterOut> argToOutputParams(Expression arg) {
        return Engine$.MODULE$.argToOutputParams(arg);
    }

    public static boolean isOutputArgOfInternalMethod(Expression arg, Semantics semantics) {
        return Engine$.MODULE$.isOutputArgOfInternalMethod(arg, semantics);
    }

    public static Vector<PathElement> expandIn(CfgNode curNode, Vector<PathElement> path, Semantics semantics) {
        return Engine$.MODULE$.expandIn(curNode, path, semantics);
    }

    private Logger logger() {
        return this.logger;
    }

    private int numberOfTasksRunning() {
        return this.numberOfTasksRunning;
    }

    private void numberOfTasksRunning_$eq(int x$1) {
        this.numberOfTasksRunning = x$1;
    }

    private ExecutorService executorService() {
        return this.executorService;
    }

    private ExecutorCompletionService<Vector<ReachableByResult>> completionService() {
        return this.completionService;
    }

    public void shutdown() {
        this.executorService().shutdown();
    }

    public List<ReachableByResult> backwards(List<CfgNode> sinks, List<CfgNode> sources) {
        if (sources.isEmpty()) {
            this.logger().info("Attempting to determine flows from empty list of sources.");
        }
        if (sinks.isEmpty()) {
            this.logger().info("Attempting to determine flows to empty list of sinks.");
        }
        Set sourcesSet = sources.toSet();
        List<ReachableByTask> tasks = this.createOneTaskPerSink((Set<CfgNode>)sourcesSet, sinks);
        return this.solveTasks(tasks, (Set<CfgNode>)sourcesSet);
    }

    private List<ReachableByTask> createOneTaskPerSink(Set<CfgNode> sourcesSet, List<CfgNode> sinks) {
        return sinks.map((Function1 & Serializable)sink -> new ReachableByTask((CfgNode)sink, sourcesSet, this.newResultTable$1(), ReachableByTask$.MODULE$.apply$default$4(), ReachableByTask$.MODULE$.apply$default$5(), ReachableByTask$.MODULE$.apply$default$6()));
    }

    private List<ReachableByResult> solveTasks(List<ReachableByTask> tasks, Set<CfgNode> sources) {
        ObjectRef result = ObjectRef.create((Object)((List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        tasks.foreach((Function1 & Serializable)task -> {
            this.submitTask(task);
            return BoxedUnit.UNIT;
        });
        this.runUntilAllTasksAreSolved$1(result, sources);
        return Engine$.MODULE$.deduplicate((Vector<ReachableByResult>)((List)result.elem).toVector()).toList();
    }

    private void submitTask(ReachableByTask task) {
        ReachableByTask reachableByTask;
        this.numberOfTasksRunning_$eq(this.numberOfTasksRunning() + 1);
        ExecutorCompletionService<Vector<ReachableByResult>> executorCompletionService = this.completionService();
        if (this.context.config().shareCacheBetweenTasks()) {
            reachableByTask = task;
        } else {
            ResultTable x$1 = new ResultTable(ResultTable$.MODULE$.$lessinit$greater$default$1());
            CfgNode x$2 = task.copy$default$1();
            Set<CfgNode> x$3 = task.copy$default$2();
            Vector<PathElement> x$4 = task.copy$default$4();
            int x$5 = task.copy$default$5();
            Stack<Call> x$6 = task.copy$default$6();
            reachableByTask = task.copy(x$2, x$3, x$1, x$4, x$5, x$6);
        }
        executorCompletionService.submit(new TaskSolver(reachableByTask, this.context));
    }

    private final ResultTable newResultTable$1() {
        return (ResultTable)this.context.config().initialTable().map((Function1 & Serializable)x -> new ResultTable((Map<StoredNode, Vector<ReachableByResult>>)((Map)x.table().clone()))).getOrElse((Function0 & Serializable)() -> new ResultTable(ResultTable$.MODULE$.$lessinit$greater$default$1()));
    }

    private final void handleResultsOfTask$1(Vector resultsOfTask, ObjectRef result$1, Set sources$1) {
        Tuple2 tuple2 = resultsOfTask.partition((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.partial()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector partial = (Vector)tuple2._1();
        Vector complete = (Vector)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partial, (Object)complete);
        Tuple2 tuple23 = tuple22;
        Vector partial2 = (Vector)tuple23._1();
        Vector complete2 = (Vector)tuple23._2();
        result$1.elem = (List)((List)result$1.elem).$plus$plus((IterableOnce)complete2);
        Vector<ReachableByTask> newTasks = new TaskCreator((Set<CfgNode>)sources$1).createFromResults((Vector<ReachableByResult>)partial2);
        newTasks.foreach((Function1 & Serializable)task -> {
            this.submitTask(task);
            return BoxedUnit.UNIT;
        });
    }

    private final void runUntilAllTasksAreSolved$1(ObjectRef result$1, Set sources$1) {
        while (this.numberOfTasksRunning() > 0) {
            BoxedUnit boxedUnit;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.completionService().take().get());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Vector resultsOfTask = (Vector)success.value();
                this.numberOfTasksRunning_$eq(this.numberOfTasksRunning() - 1);
                this.handleResultsOfTask$1(resultsOfTask, result$1, sources$1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.numberOfTasksRunning_$eq(this.numberOfTasksRunning() - 1);
                this.logger().warn("SolveTask failed with exception:", exception);
                exception.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public Engine(EngineContext context) {
        this.context = context;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.numberOfTasksRunning = 0;
        this.executorService = Executors.newWorkStealingPool();
        this.completionService = new ExecutorCompletionService(this.executorService());
    }
}

