/*
 * Decompiled with CFR 0.152.
 */
package io.joern.dataflowengineoss.queryengine;

import io.joern.dataflowengineoss.queryengine.Engine$;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.dataflowengineoss.queryengine.PathElement;
import io.joern.dataflowengineoss.queryengine.ReachableByResult;
import io.joern.dataflowengineoss.queryengine.ReachableByTask;
import io.joern.dataflowengineoss.queryengine.ReachableByTask$;
import io.joern.dataflowengineoss.queryengine.ResultTable;
import io.joern.dataflowengineoss.queryengine.ResultTable$;
import io.joern.dataflowengineoss.queryengine.TaskFingerprint;
import io.joern.dataflowengineoss.queryengine.TaskSolver;
import io.joern.dataflowengineoss.semanticsloader.FlowSemantic;
import io.joern.dataflowengineoss.semanticsloader.Semantics;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import java.io.Serializable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.traversal.Traversal;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t]d\u0001\u0002\u0013&\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001a\u0001\n\u0013Q\u0005b\u0002(\u0001\u0001\u0004%Ia\u0014\u0005\u0007+\u0002\u0001\u000b\u0015B&\t\u000fY\u0003!\u0019!C\u0005/\"1!\r\u0001Q\u0001\naCqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004\u007f\u0001\u0001\u0006I!\u001a\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011\u0011\u0004\u0001!\u0002\u0013\t\u0019\u0001C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u00111\n\u0001\u0005\n\u00055\u0003bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003s\u0002A\u0011BA>\u000f\u001d\t\u0019)\nE\u0001\u0003\u000b3a\u0001J\u0013\t\u0002\u0005\u001d\u0005B\u0002\u001e\u0015\t\u0003\tI\tC\u0004\u0002\fR!\t!!$\t\u0013\u0005uF#%A\u0005\u0002\u0005}\u0006bBAk)\u0011%\u0011q\u001b\u0005\n\u0003k$\u0012\u0013!C\u0005\u0003\u007fCq!a>\u0015\t\u0003\tI\u0010C\u0004\u0003\u0010Q!IA!\u0005\t\u0013\tuA#%A\u0005\n\u0005}\u0006b\u0002B\u0010)\u0011\u0005!\u0011\u0005\u0005\b\u0005o!B\u0011\u0001B\u001d\u0011\u001d\u0011)\u0005\u0006C\u0001\u0005\u000fBqA!\u0014\u0015\t\u0003\u0011y\u0005C\u0004\u0003TQ!\tA!\u0016\t\u000f\tuC\u0003\"\u0001\u0003`!9!q\u000e\u000b\u0005\u0002\tE$AB#oO&tWM\u0003\u0002'O\u0005Y\u0011/^3ss\u0016tw-\u001b8f\u0015\tA\u0013&A\teCR\fg\r\\8xK:<\u0017N\\3pgNT!AK\u0016\u0002\u000b)|WM\u001d8\u000b\u00031\n!![8\u0004\u0001M\u0011\u0001a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\r|g\u000e^3yiB\u0011q\u0007O\u0007\u0002K%\u0011\u0011(\n\u0002\u000e\u000b:<\u0017N\\3D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\taT\b\u0005\u00028\u0001!)QG\u0001a\u0001m\u00051An\\4hKJ,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bQa\u001d7gi)T\u0011!R\u0001\u0004_J<\u0017BA$C\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001\u00068v[\n,'o\u00144UCN\\7OU;o]&tw-F\u0001L!\t\u0001D*\u0003\u0002Nc\t\u0019\u0011J\u001c;\u000219,XNY3s\u001f\u001a$\u0016m]6t%Vtg.\u001b8h?\u0012*\u0017\u000f\u0006\u0002Q'B\u0011\u0001'U\u0005\u0003%F\u0012A!\u00168ji\"9AKBA\u0001\u0002\u0004Y\u0015a\u0001=%c\u0005)b.^7cKJ|e\rV1tWN\u0014VO\u001c8j]\u001e\u0004\u0013aD3yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0016\u0003a\u0003\"!\u00171\u000e\u0003iS!a\u0017/\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002^=\u0006!Q\u000f^5m\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019.\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0001#\u001a=fGV$xN]*feZL7-\u001a\u0011\u0002#\r|W\u000e\u001d7fi&|gnU3sm&\u001cW-F\u0001f!\rIf\r[\u0005\u0003Oj\u0013\u0011$\u0012=fGV$xN]\"p[BdW\r^5p]N+'O^5dKB!\u0001'[6{\u0013\tQ\u0017G\u0001\u0004UkBdWM\r\t\u0004YR<hBA7s\u001d\tq\u0017/D\u0001p\u0015\t\u0001X&\u0001\u0004=e>|GOP\u0005\u0002e%\u00111/M\u0001\ba\u0006\u001c7.Y4f\u0013\t)hO\u0001\u0004WK\u000e$xN\u001d\u0006\u0003gF\u0002\"a\u000e=\n\u0005e,#!\u0005*fC\u000eD\u0017M\u00197f\u0005f\u0014Vm];miB\u0019A\u000e^>\u0011\u0005]b\u0018BA?&\u0005=\u0011V-Y2iC\ndWMQ=UCN\\\u0017AE2p[BdW\r^5p]N+'O^5dK\u0002\nqa\u001d;beR,G-\u0006\u0002\u0002\u0004A1\u0011QAA\b\u0003'i!!a\u0002\u000b\t\u0005%\u00111B\u0001\b[V$\u0018M\u00197f\u0015\r\ti!M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\t\u0003\u000f\u00111aU3u!\r9\u0014QC\u0005\u0004\u0003/)#a\u0004+bg.4\u0015N\\4feB\u0014\u0018N\u001c;\u0002\u0011M$\u0018M\u001d;fI\u0002\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002!\u0006I!-Y2lo\u0006\u0014Hm\u001d\u000b\u0007\u0003G\tI#a\u0012\u0011\t1\f)c^\u0005\u0004\u0003O1(\u0001\u0002'jgRDq!a\u000b\u0010\u0001\u0004\ti#A\u0003tS:\\7\u000fE\u0003m\u0003K\ty\u0003\u0005\u0003\u00022\u0005\rSBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u000b9|G-Z:\u000b\t\u0005e\u00121H\u0001\nO\u0016tWM]1uK\u0012TA!!\u0010\u0002@\u0005\t2m\u001c3faJ|\u0007/\u001a:us\u001e\u0014\u0018\r\u001d5\u000b\u0007\u0005\u00053&A\u0005tQ&4G\u000f\\3gi&!\u0011QIA\u001a\u0005\u001d\u0019em\u001a(pI\u0016Dq!!\u0013\u0010\u0001\u0004\ti#A\u0004t_V\u00148-Z:\u0002)\r\u0014X-\u0019;f\u001f:,G+Y:l!\u0016\u00148+\u001b8l)\u0019\ty%!\u0017\u0002lA)\u0011\u0011KA,w6\u0011\u00111\u000b\u0006\u0005\u0003+\nY!A\u0005j[6,H/\u00192mK&!\u0011qEA*\u0011\u001d\tY\u0006\u0005a\u0001\u0003;\n!b]8ve\u000e,7oU3u!\u0019\ty&a\u001a\u000209!\u0011\u0011MA2!\tq\u0017'C\u0002\u0002fE\na\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003SR1!!\u001a2\u0011\u001d\tY\u0003\u0005a\u0001\u0003[\t!b]8mm\u0016$\u0016m]6t)\u0019\t\u0019#!\u001d\u0002x!9\u00111O\tA\u0002\u0005U\u0014!\u0002;bg.\u001c\b\u0003\u00027\u0002&mDq!!\u0013\u0012\u0001\u0004\ti&\u0001\u0006tk\nl\u0017\u000e\u001e+bg.$R\u0001UA?\u0003\u0003Ca!a \u0013\u0001\u0004Y\u0018\u0001\u0002;bg.Dq!!\u0013\u0013\u0001\u0004\ti&\u0001\u0004F]\u001eLg.\u001a\t\u0003oQ\u0019\"\u0001F\u0018\u0015\u0005\u0005\u0015\u0015\u0001C3ya\u0006tG-\u00138\u0015\u0011\u0005=\u0015\u0011VAW\u0003c#B!!%\u0002\u001aB!A\u000e^AJ!\r9\u0014QS\u0005\u0004\u0003/+#a\u0003)bi\",E.Z7f]RDq!a'\u0017\u0001\b\ti*A\u0005tK6\fg\u000e^5dgB!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$\u001e\nqb]3nC:$\u0018nY:m_\u0006$WM]\u0005\u0005\u0003O\u000b\tKA\u0005TK6\fg\u000e^5dg\"9\u00111\u0016\fA\u0002\u0005=\u0012aB2ve:{G-\u001a\u0005\b\u0003_3\u0002\u0019AAI\u0003\u0011\u0001\u0018\r\u001e5\t\u0013\u0005Mf\u0003%AA\u0002\u0005U\u0016!D2bY2\u001c\u0016\u000e^3Ti\u0006\u001c7\u000eE\u0003m\u0003K\t9\f\u0005\u0003\u00022\u0005e\u0016\u0002BA^\u0003g\u0011AaQ1mY\u0006\u0011R\r\u001f9b]\u0012Le\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tM\u000b\u0003\u00026\u0006\r7FAAc!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0017'\u0001\u0006b]:|G/\u0019;j_:LA!a5\u0002J\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0017\u0015dW-\u001c$pe\u0016#w-\u001a\u000b\u0007\u00033\f\u0019/a=\u0015\t\u0005m\u0017\u0011\u001d\t\u0006a\u0005u\u00171S\u0005\u0004\u0003?\f$AB(qi&|g\u000eC\u0004\u0002\u001cb\u0001\u001d!!(\t\u000f\u0005\u0015\b\u00041\u0001\u0002h\u0006\tQ\r\u0005\u0003\u0002j\u0006=XBAAv\u0015\t\ti/\u0001\u0006pm\u0016\u0014h\r\\8xI\nLA!!=\u0002l\n!Q\tZ4f\u0011%\t\u0019\f\u0007I\u0001\u0002\u0004\t),A\u000bfY\u0016lgi\u001c:FI\u001e,G\u0005Z3gCVdG\u000f\n\u001a\u00027%\u001cx*\u001e;qkR\f%oZ(g\u0013:$XM\u001d8bY6+G\u000f[8e)\u0011\tYP!\u0002\u0015\t\u0005u(1\u0001\t\u0004a\u0005}\u0018b\u0001B\u0001c\t9!i\\8mK\u0006t\u0007bBAN5\u0001\u000f\u0011Q\u0014\u0005\b\u0005\u000fQ\u0002\u0019\u0001B\u0005\u0003\r\t'o\u001a\t\u0005\u0003c\u0011Y!\u0003\u0003\u0003\u000e\u0005M\"AC#yaJ,7o]5p]\u00061A\rZ4J]\u0016#\u0002Ba\u0005\u0003\u0016\te!1\u0004\t\u0005YR\f9\u000fC\u0004\u0003\u0018m\u0001\r!a\f\u0002\t9|G-\u001a\u0005\b\u0003_[\u0002\u0019AAI\u0011%\t\u0019l\u0007I\u0001\u0002\u0004\t),\u0001\teI\u001eLe.\u0012\u0013eK\u001a\fW\u000f\u001c;%g\u0005\t\u0012M]4U_>+H\u000f];u!\u0006\u0014\u0018-\\:\u0015\t\t\r\"Q\u0007\t\u0007\u0005K\u0011YCa\f\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0003W\f\u0011\u0002\u001e:bm\u0016\u00148/\u00197\n\t\t5\"q\u0005\u0002\n)J\fg/\u001a:tC2\u0004B!!\r\u00032%!!1GA\u001a\u0005IiU\r\u001e5pIB\u000b'/Y7fi\u0016\u0014x*\u001e;\t\u000f\t\u001dQ\u00041\u0001\u0003\n\u0005a\u0011M]4U_6+G\u000f[8egR!!1\bB\"!\u0015a\u0017Q\u0005B\u001f!\u0011\t\tDa\u0010\n\t\t\u0005\u00131\u0007\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000f\t\u001da\u00041\u0001\u0003\n\u0005qQ.\u001a;i_\u0012\u001chi\u001c:DC2dG\u0003\u0002B\u001e\u0005\u0013BqAa\u0013 \u0001\u0004\t9,\u0001\u0003dC2d\u0017AF5t\u0007\u0006dG\u000eV8J]R,'O\\1m\u001b\u0016$\bn\u001c3\u0015\t\u0005u(\u0011\u000b\u0005\b\u0005\u0017\u0002\u0003\u0019AA\\\u0003\u0015J7oQ1mYR{\u0017J\u001c;fe:\fG.T3uQ>$w+\u001b;i_V$8+Z7b]RL7\r\u0006\u0003\u0003X\tmC\u0003BA\u007f\u00053Bq!a'\"\u0001\b\ti\nC\u0004\u0003L\u0005\u0002\r!a.\u0002!M,W.\u00198uS\u000e\u001chi\u001c:DC2dG\u0003\u0002B1\u0005[\"BAa\u0019\u0003lA)A.!\n\u0003fA!\u0011q\u0014B4\u0013\u0011\u0011I'!)\u0003\u0019\u0019cwn^*f[\u0006tG/[2\t\u000f\u0005m%\u0005q\u0001\u0002\u001e\"9!1\n\u0012A\u0002\u0005]\u0016a\u00033fIV\u0004H.[2bi\u0016$2a\u001bB:\u0011\u0019\u0011)h\ta\u0001W\u0006\u0019a/Z2")
public class Engine {
    private final EngineContext context;
    private final Logger logger;
    private int numberOfTasksRunning;
    private final ExecutorService executorService;
    private final ExecutorCompletionService<Tuple2<Vector<ReachableByResult>, Vector<ReachableByTask>>> completionService;
    private final Set<TaskFingerprint> started;

    public static Vector<ReachableByResult> deduplicate(Vector<ReachableByResult> vec) {
        return Engine$.MODULE$.deduplicate(vec);
    }

    public static List<FlowSemantic> semanticsForCall(Call call, Semantics semantics) {
        return Engine$.MODULE$.semanticsForCall(call, semantics);
    }

    public static boolean isCallToInternalMethodWithoutSemantic(Call call, Semantics semantics) {
        return Engine$.MODULE$.isCallToInternalMethodWithoutSemantic(call, semantics);
    }

    public static boolean isCallToInternalMethod(Call call) {
        return Engine$.MODULE$.isCallToInternalMethod(call);
    }

    public static List<Method> methodsForCall(Call call) {
        return Engine$.MODULE$.methodsForCall(call);
    }

    public static List<Method> argToMethods(Expression arg) {
        return Engine$.MODULE$.argToMethods(arg);
    }

    public static Traversal<MethodParameterOut> argToOutputParams(Expression arg) {
        return Engine$.MODULE$.argToOutputParams(arg);
    }

    public static boolean isOutputArgOfInternalMethod(Expression arg, Semantics semantics) {
        return Engine$.MODULE$.isOutputArgOfInternalMethod(arg, semantics);
    }

    public static List<Call> expandIn$default$3() {
        return Engine$.MODULE$.expandIn$default$3();
    }

    public static Vector<PathElement> expandIn(CfgNode curNode, Vector<PathElement> path, List<Call> callSiteStack, Semantics semantics) {
        return Engine$.MODULE$.expandIn(curNode, path, callSiteStack, semantics);
    }

    private Logger logger() {
        return this.logger;
    }

    private int numberOfTasksRunning() {
        return this.numberOfTasksRunning;
    }

    private void numberOfTasksRunning_$eq(int x$1) {
        this.numberOfTasksRunning = x$1;
    }

    private ExecutorService executorService() {
        return this.executorService;
    }

    private ExecutorCompletionService<Tuple2<Vector<ReachableByResult>, Vector<ReachableByTask>>> completionService() {
        return this.completionService;
    }

    private Set<TaskFingerprint> started() {
        return this.started;
    }

    public void shutdown() {
        this.executorService().shutdown();
    }

    public List<ReachableByResult> backwards(List<CfgNode> sinks, List<CfgNode> sources) {
        if (sources.isEmpty()) {
            this.logger().info("Attempting to determine flows from empty list of sources.");
        }
        if (sinks.isEmpty()) {
            this.logger().info("Attempting to determine flows to empty list of sinks.");
        }
        scala.collection.immutable.Set sourcesSet = sources.toSet();
        List<ReachableByTask> tasks = this.createOneTaskPerSink((scala.collection.immutable.Set<CfgNode>)sourcesSet, sinks);
        return this.solveTasks(tasks, (scala.collection.immutable.Set<CfgNode>)sourcesSet);
    }

    private List<ReachableByTask> createOneTaskPerSink(scala.collection.immutable.Set<CfgNode> sourcesSet, List<CfgNode> sinks) {
        return sinks.map((Function1 & Serializable)sink -> new ReachableByTask((CfgNode)sink, sourcesSet, this.newResultTable$1(), ReachableByTask$.MODULE$.apply$default$4(), ReachableByTask$.MODULE$.apply$default$5(), ReachableByTask$.MODULE$.apply$default$6()));
    }

    private List<ReachableByResult> solveTasks(List<ReachableByTask> tasks, scala.collection.immutable.Set<CfgNode> sources) {
        ObjectRef completedResults = ObjectRef.create((Object)((List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        tasks.foreach((Function1 & Serializable)task -> {
            this.submitTask(task, (scala.collection.immutable.Set<CfgNode>)sources);
            return BoxedUnit.UNIT;
        });
        this.runUntilAllTasksAreSolved$1(completedResults, sources);
        return Engine$.MODULE$.deduplicate((Vector<ReachableByResult>)((List)completedResults.elem).toVector()).toList();
    }

    private void submitTask(ReachableByTask task, scala.collection.immutable.Set<CfgNode> sources) {
        ReachableByTask reachableByTask;
        TaskFingerprint fingerprint = new TaskFingerprint(task.sink(), task.sources(), task.callDepth(), task.callSiteStack());
        if (this.started().contains((Object)fingerprint)) {
            return;
        }
        this.started().add((Object)fingerprint);
        this.numberOfTasksRunning_$eq(this.numberOfTasksRunning() + 1);
        ExecutorCompletionService<Tuple2<Vector<ReachableByResult>, Vector<ReachableByTask>>> executorCompletionService = this.completionService();
        if (this.context.config().shareCacheBetweenTasks()) {
            reachableByTask = task;
        } else {
            ResultTable x$1 = new ResultTable(ResultTable$.MODULE$.$lessinit$greater$default$1());
            CfgNode x$2 = task.copy$default$1();
            scala.collection.immutable.Set<CfgNode> x$3 = task.copy$default$2();
            Vector<PathElement> x$4 = task.copy$default$4();
            int x$5 = task.copy$default$5();
            List<Call> x$6 = task.copy$default$6();
            reachableByTask = task.copy(x$2, x$3, x$1, x$4, x$5, x$6);
        }
        executorCompletionService.submit(new TaskSolver(reachableByTask, this.context, sources));
    }

    private final ResultTable newResultTable$1() {
        return (ResultTable)this.context.config().initialTable().map((Function1 & Serializable)x -> new ResultTable((Map<StoredNode, Vector<ReachableByResult>>)((Map)x.table().clone()))).getOrElse((Function0 & Serializable)() -> new ResultTable(ResultTable$.MODULE$.$lessinit$greater$default$1()));
    }

    private final void handleResultsOfTask$1(Tuple2 resultsOfTask, ObjectRef completedResults$1, scala.collection.immutable.Set sources$1) {
        completedResults$1.elem = (List)((List)completedResults$1.elem).$plus$plus((IterableOnce)resultsOfTask._1());
        Vector newTasks = (Vector)resultsOfTask._2();
        newTasks.foreach((Function1 & Serializable)task -> {
            this.submitTask(task, (scala.collection.immutable.Set<CfgNode>)sources$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void runUntilAllTasksAreSolved$1(ObjectRef completedResults$1, scala.collection.immutable.Set sources$1) {
        while (this.numberOfTasksRunning() > 0) {
            BoxedUnit boxedUnit;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.completionService().take().get());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Tuple2 resultsOfTask = (Tuple2)success.value();
                this.numberOfTasksRunning_$eq(this.numberOfTasksRunning() - 1);
                this.handleResultsOfTask$1(resultsOfTask, completedResults$1, sources$1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.numberOfTasksRunning_$eq(this.numberOfTasksRunning() - 1);
                this.logger().warn("SolveTask failed with exception:", exception);
                exception.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public Engine(EngineContext context) {
        this.context = context;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.numberOfTasksRunning = 0;
        this.executorService = Executors.newWorkStealingPool();
        this.completionService = new ExecutorCompletionService(this.executorService());
        this.started = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

