/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.antlrparsers.moduleparser;

import io.joern.fuzzyc2cpg.ModuleParser;
import io.joern.fuzzyc2cpg.antlrparsers.moduleparser.ModuleParserTest;
import org.antlr.v4.runtime.Parser;
import org.junit.Assert;
import org.junit.Test;

public class OtherTests
extends ModuleParserTest {
    @Test
    public void testNestedFunctionName() {
        String input = "int (foo)(){}";
        ModuleParser parser = this.createParser(input);
        String output = parser.function_def().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.startsWith("(function_def "));
    }

    @Test
    public void testOperatorOverloading() {
        String input = "inline bool operator == (const PlMessageHeader &b) const {}";
        ModuleParser parser = this.createParser(input);
        String output = parser.function_def().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.startsWith("(function_def "));
    }

    @Test
    public void testExceptionSpecificationCpp() {
        String input = "int foo() throw(){}";
        ModuleParser parser = this.createParser(input);
        String output = parser.function_def().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.startsWith("(function_def "));
    }

    @Test
    public void testMultilineString() {
        String input = "char* c = \"This is \"\n\"a multiline \"\n\"string.\";";
        ModuleParser parser = this.createParser(input);
        String output = parser.var_decl().toStringTree((Parser)parser);
        Assert.assertEquals((Object)"(var_decl (type_name (base_type char)) (init_declarator_list (init_declarator (declarator (ptrs (ptr_operator *)) (identifier c)) = (assign_expr_w_ (assign_water \"This is \"\\n\"a multiline \"\\n\"string.\"))) ;))", (Object)output);
    }

    @Test
    public void testStringConcatWithIdentifier() {
        String input = "char* c = \"start\"SOME_VAR\"end\";";
        ModuleParser parser = this.createParser(input);
        String output = parser.var_decl().toStringTree((Parser)parser);
        Assert.assertEquals((Object)"(var_decl (type_name (base_type char)) (init_declarator_list (init_declarator (declarator (ptrs (ptr_operator *)) (identifier c)) = (assign_expr_w_ (assign_water \"start\"SOME_VAR\"end\"))) ;))", (Object)output);
    }

    @Test
    public void testMultipleDeclarations() {
        String input = "int x, y;";
        ModuleParser parser = this.createParser(input);
        String output = parser.simple_decl().toStringTree((Parser)parser);
        Assert.assertEquals((Object)"(simple_decl (var_decl (type_name (base_type int)) (init_declarator_list (init_declarator (declarator (identifier x))) , (init_declarator (declarator (identifier y))) ;)))", (Object)output);
    }

    @Test
    public void testEmojiFuncComment() {
        String input = "int meaning_of_life() {\n  // This is the peach emoji: \ud83c\udf51\n  const auto x = *y;\n  return 42;\n}";
        ModuleParser parser = this.createParser(input);
        String output = parser.function_def().toStringTree((Parser)parser);
        Assert.assertEquals((Object)"(function_def (return_type (type_name (base_type int))) (function_name (identifier meaning_of_life)) (function_param_list ( )) (compound_statement { const auto x = * y ; return 42 ; }))", (Object)output);
    }
}

