/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.antlrparsers.moduleparser;

import io.joern.fuzzyc2cpg.ModuleParser;
import io.joern.fuzzyc2cpg.antlrparsers.moduleparser.ModuleParserTest;
import org.antlr.v4.runtime.Parser;
import org.junit.Assert;
import org.junit.Test;

public class PreprocessorTests
extends ModuleParserTest {
    @Test
    public void testPreprocessorIfs() {
        String input = "int foo(){ #if bar\n { #endif\n}";
        ModuleParser parser = this.createParser(input);
        String output = parser.function_def().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.startsWith("(function_def "));
    }

    @Test
    public void testNestedPreprocessorIfs() {
        String input = "int foo(){ #if bar\n #if bar2\n { #endif #endif\n}";
        ModuleParser parser = this.createParser(input);
        String output = parser.function_def().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.startsWith("(function_def "));
    }

    @Test
    public void testPreprocIfBeforeFunc() {
        String input = "#ifdef foo\nint foo(){ #if x\n foo();\n #else\n #endif\n} abc\n #endif\n";
        ModuleParser parser = this.createParser(input);
        String output = parser.code().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.contains("(water abc)"));
    }

    @Test
    public void testPreprocIfNesting() {
        String input = "foo(){ #ifdef x\n #ifdef y\n #else\n #endif\n#endif\n abc(); } foo();";
        ModuleParser parser = this.createParser(input);
        String output = parser.code().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.contains("(compound_statement { #ifdef x\\n #ifdef y\\n #else\\n #endif\\n #endif\\n abc ( ) ; }))"));
    }

    @Test
    public void testPreprocIfInElse() {
        String input = "foo(){ #ifdef x\n #else\n #ifdef y\n #endif\n#endif\n abc(); } foo();";
        ModuleParser parser = this.createParser(input);
        String output = parser.code().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.contains("(compound_statement { #ifdef x\\n #else\\n #ifdef y\\n #endif\\n #endif\\n abc ( ) ; }))"));
    }

    @Test
    public void testStartingPreProcElse() {
        String input = "#ifdef foo\n int foo(){ #else\n {\n#endif\n } abc\n #endif\n";
        ModuleParser parser = this.createParser(input);
        String output = parser.code().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.contains("(water abc)"));
    }

    @Test
    public void testPreprocPlusDecl() {
        String input = "#ifndef FUNCTIONS_H\n#define FUNCTIONS_H\n void call_function();\n int glob;\n#endif\n";
        ModuleParser parser = this.createParser(input);
        String output = parser.code().toStringTree((Parser)parser);
        Assert.assertTrue((boolean)output.contains("(type_name (base_type void))"));
    }
}

