/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.parsetreetoast;

import io.joern.fuzzyc2cpg.ast.expressions.Condition;
import io.joern.fuzzyc2cpg.ast.expressions.Expression;
import io.joern.fuzzyc2cpg.ast.langc.statements.blockstarters.ElseStatement;
import io.joern.fuzzyc2cpg.ast.langc.statements.blockstarters.IfStatement;
import io.joern.fuzzyc2cpg.ast.logical.statements.BlockStarter;
import io.joern.fuzzyc2cpg.ast.logical.statements.CompoundStatement;
import io.joern.fuzzyc2cpg.parsetreetoast.FunctionContentTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class IfNestingTests {
    @Test
    public void ifBlockCompound() {
        String input = "if(foo){}";
        CompoundStatement compound = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        this.assertFirstChildIsIfStatement(compound);
    }

    @Test
    public void ifBlockNoCompound() {
        String input = "if(foo) bar();";
        CompoundStatement compound = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        this.assertFirstChildIsIfStatement(compound);
    }

    @Test
    public void nestedIfBlocksNoCompound() {
        String input = "if(foo) if(fooAgain) bar();";
        CompoundStatement compound = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        IfStatement ifStatement = (IfStatement)compound.getStatements().get(0);
        IfStatement innerStatement = (IfStatement)ifStatement.getStatement();
        this.assertFirstChildIsIfStatement(compound);
        Assert.assertTrue((innerStatement.getCondition() != null ? 1 : 0) != 0);
    }

    @Test
    public void conditionString() {
        String input = "if(foo){}";
        CompoundStatement item = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        BlockStarter starter = (BlockStarter)item.getStatements().get(0);
        Expression condition = ((Condition)starter.getCondition()).getExpression();
        Assert.assertTrue((boolean)condition.getEscapedCodeStr().equals("foo"));
    }

    @Test
    public void ifElse() {
        String input = "if(foo) lr->f = stdin; else lr->f = fopen(pathname, \"r\");";
        CompoundStatement compound = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        this.assertFirstChildIsIfStatement(compound);
        this.assertFirstIfHasElse(compound);
    }

    @Test
    public void ifElseChain() {
        String input = "if(foo1) bar1(); else if(foo2) bar2(); else if(foo3) bar3();";
        CompoundStatement compound = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        IfStatement ifItem = (IfStatement)compound.getStatements().get(0);
        for (int i = 0; i < 2; ++i) {
            this.assertHasElse(ifItem);
            ifItem = (IfStatement)ifItem.getElseNode().getStatement();
        }
    }

    @Test
    public void ifInElse() {
        String input = "if (foo1){} else { if (foo2) { foo(); } }";
        CompoundStatement compound = (CompoundStatement)FunctionContentTestUtil.parseAndWalk(input);
        IfStatement ifItem = (IfStatement)compound.getStatements().get(0);
        this.assertFirstChildIsIfStatement(compound);
        this.assertFirstIfHasElse(compound);
        ElseStatement elseNode = ifItem.getElseNode();
        CompoundStatement innerCompound = (CompoundStatement)elseNode.getStatement();
        Assert.assertTrue((innerCompound.getChildCount() == 1 ? 1 : 0) != 0);
        IfStatement innerIf = (IfStatement)innerCompound.getChild(0);
        Assert.assertTrue((innerIf.getCondition() != null ? 1 : 0) != 0);
    }

    private void assertFirstChildIsIfStatement(CompoundStatement compound) {
        IfStatement ifStatement = (IfStatement)compound.getStatements().get(0);
        Assert.assertTrue((compound.getStatements().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((ifStatement.getCondition() != null ? 1 : 0) != 0);
    }

    private void assertFirstIfHasElse(CompoundStatement compound) {
        IfStatement ifItem = (IfStatement)compound.getStatements().get(0);
        this.assertHasElse(ifItem);
    }

    private void assertHasElse(IfStatement ifItem) {
        ElseStatement elseNode = ifItem.getElseNode();
        Assert.assertTrue((elseNode != null ? 1 : 0) != 0);
        Assert.assertTrue((elseNode.getChild(0) != null ? 1 : 0) != 0);
    }
}

