/*
 * Decompiled with CFR 0.152.
 */
package io.joern.fuzzyc2cpg.antlrparsers.functionparser;

import io.joern.fuzzyc2cpg.FunctionParser;
import io.joern.fuzzyc2cpg.antlrparsers.functionparser.FunctionParserTestBase;
import io.joern.fuzzyc2cpg.passes.astcreation.AntlrParserDriver;
import org.antlr.v4.runtime.tree.ParseTree;
import org.junit.Assert;
import org.junit.Test;

public class FunctionCommentTests
extends FunctionParserTestBase {
    @Test
    public void testLineComment() {
        String input = "// This is a comment!";
        FunctionParser parser = this.createHiddenParser(input);
        Assert.assertEquals((Object)parser.getCurrentToken().getText(), (Object)"// This is a comment!");
    }

    @Test
    public void testLineCommentAfterStatement() {
        String input = "int x = 5; // This is a comment!";
        FunctionParser parser = this.createHiddenParser(input);
        Assert.assertEquals((Object)parser.getCurrentToken().getText(), (Object)"// This is a comment!");
    }

    @Test
    public void testBlockComment() {
        String input = "/* This is a block comment! */";
        FunctionParser parser = this.createHiddenParser(input);
        Assert.assertEquals((Object)parser.getCurrentToken().getText(), (Object)"/* This is a block comment! */");
    }

    @Test
    public void testBlockCommentWithinStatement() {
        String input = "int /* This is a block comment! */ x = 5;";
        FunctionParser parser = this.createHiddenParser(input);
        Assert.assertEquals((Object)parser.getCurrentToken().getText(), (Object)"/* This is a block comment! */");
    }

    @Test
    public void testLineCommentWithEmoji() {
        String input = "int x = 5; // Peachy! \ud83c\udf51";
        FunctionParser parser = this.createHiddenParser(input);
        Assert.assertEquals((Object)parser.getCurrentToken().getText(), (Object)"// Peachy! \ud83c\udf51");
    }

    @Test
    public void testBlockCommentWithEmoji() {
        String input = "int x = 5; // Peachy! \ud83c\udf51";
        FunctionParser parser = this.createHiddenParser(input);
        Assert.assertEquals((Object)parser.getCurrentToken().getText(), (Object)"// Peachy! \ud83c\udf51");
    }

    private void compareParses(String actual, String expected) {
        AntlrParserDriver functionParser = this.createFunctionDriver();
        ParseTree actualTree = functionParser.parseString(actual);
        ParseTree expectedTree = functionParser.parseString(expected);
        String actualOutput = actualTree.toStringTree(functionParser.getAntlrParser());
        String expectedOutput = expectedTree.toStringTree(functionParser.getAntlrParser());
        Assert.assertEquals((Object)actualOutput, (Object)expectedOutput);
    }

    @Test
    public void testLineCommentDriver() {
        String inputWithComment = "// This is a comment!";
        String inputWithoutComment = "";
        this.compareParses(inputWithComment, inputWithoutComment);
    }

    @Test
    public void testLineCommentAfterStatementDriver() {
        String inputWithComment = "int x = 5; // This is a comment!";
        String inputWithoutComment = "int x = 5;";
        this.compareParses(inputWithComment, inputWithoutComment);
    }

    @Test
    public void testBlockCommentDriver() {
        String inputWithComment = "/* This is a block comment! */";
        String inputWithoutComment = "";
        this.compareParses(inputWithComment, inputWithoutComment);
    }

    @Test
    public void testBlockCommentWithinStatementDriver() {
        String inputWithComment = "int /* This is a block comment! */ x = 5;";
        String inputWithoutComment = "int x = 5;";
        this.compareParses(inputWithComment, inputWithoutComment);
    }

    @Test
    public void testLineCommentWithEmojiDriver() {
        String inputWithComment = "int x = 5; // Peachy! \ud83c\udf51";
        String inputWithoutComment = "int x = 5;";
        this.compareParses(inputWithComment, inputWithoutComment);
    }

    @Test
    public void testBlockCommentWithEmojiDriver() {
        String inputWithComment = "int /* Peachy! \ud83c\udf51 */ x = 5;";
        String inputWithoutComment = "int x = 5;";
        this.compareParses(inputWithComment, inputWithoutComment);
    }
}

